/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.logging.jboss;

import cz.auderis.test.logging.LogLevel;
import cz.auderis.test.logging.LogRecord;
import cz.auderis.test.logging.LogRecordCollector;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.jboss.logging.Logger;

public class JBossLoggerAdapter
extends Logger {
    public static final Map<Logger.Level, LogLevel> JBOSS_TO_INTERNAL = JBossLoggerAdapter.prepareLevelMap();

    private static Map<Logger.Level, LogLevel> prepareLevelMap() {
        EnumMap<Logger.Level, LogLevel> levelMap = new EnumMap<Logger.Level, LogLevel>(Logger.Level.class);
        levelMap.put(Logger.Level.TRACE, LogLevel.TRACE);
        levelMap.put(Logger.Level.DEBUG, LogLevel.DEBUG);
        levelMap.put(Logger.Level.INFO, LogLevel.INFO);
        levelMap.put(Logger.Level.WARN, LogLevel.WARNING);
        levelMap.put(Logger.Level.ERROR, LogLevel.ERROR);
        levelMap.put(Logger.Level.FATAL, LogLevel.FATAL);
        return Collections.unmodifiableMap(levelMap);
    }

    protected JBossLoggerAdapter(String name) {
        super(name);
    }

    public boolean isEnabled(Logger.Level level) {
        LogLevel internalLevel = JBOSS_TO_INTERNAL.get(level);
        return LogRecordCollector.RECORD_COLLECTOR.isLevelEnabled(internalLevel);
    }

    protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel internalLevel = JBOSS_TO_INTERNAL.get(level);
        if (!recordCollector.isLevelEnabled(internalLevel)) {
            return;
        }
        String message = null == parameters ? format : String.format(format, parameters);
        LogRecord record = new LogRecord(internalLevel, loggerClassName, message, thrown);
        recordCollector.add(record);
    }

    protected void doLog(Logger.Level level, String loggerClassName, Object msgObj, Object[] parameters, Throwable thrown) {
        LogRecordCollector recordCollector = LogRecordCollector.RECORD_COLLECTOR;
        LogLevel internalLevel = JBOSS_TO_INTERNAL.get(level);
        if (!recordCollector.isLevelEnabled(internalLevel)) {
            return;
        }
        String message = null == parameters || 0 == parameters.length ? String.valueOf(msgObj) : MessageFormat.format(String.valueOf(msgObj), parameters);
        LogRecord record = new LogRecord(internalLevel, loggerClassName, message, thrown);
        recordCollector.add(record);
    }
}

