/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.array;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ArrayPartMatcher
extends TypeSafeMatcher<Object[]> {
    final Object[] referenceSubarray;
    final int referenceLength;
    Integer requiredOffset;
    Matcher<? super Integer> matchStartMatcher;
    Matcher<? super Integer> matchEndMatcher;
    MatcherImplementation matcher;

    public static <T> ArrayPartMatcher contains(T ... referenceItems) {
        return new ArrayPartMatcher(referenceItems);
    }

    public static <T> Matcher<? super Object[]> startsWith(T ... referenceItems) {
        ArrayPartMatcher matcher = new ArrayPartMatcher(referenceItems);
        matcher.withStartIndex(0);
        return matcher;
    }

    public static <T> Matcher<? super Object[]> endsWith(T ... referenceItems) {
        ArrayPartMatcher matcher = new ArrayPartMatcher(referenceItems);
        matcher.withNumberOfFollowingItems(0);
        return matcher;
    }

    public ArrayPartMatcher withStartIndex(int idx) {
        if (idx < 0) {
            throw new IllegalArgumentException("Start index must be non-negative: " + idx);
        }
        this.requiredOffset = idx;
        this.matchStartMatcher = null;
        this.matchEndMatcher = null;
        this.reinitialize();
        return this;
    }

    public ArrayPartMatcher withStartIndex(Matcher<? super Integer> startIndexConstraint) {
        if (null == startIndexConstraint) {
            throw new NullPointerException();
        }
        this.requiredOffset = null;
        this.matchStartMatcher = startIndexConstraint;
        this.reinitialize();
        return this;
    }

    public ArrayPartMatcher withNumberOfFollowingItems(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Following item count must be non-negative: " + count);
        }
        this.requiredOffset = -count - 1;
        this.matchStartMatcher = null;
        this.matchEndMatcher = null;
        this.reinitialize();
        return this;
    }

    public ArrayPartMatcher withNumberOfFollowingItems(Matcher<? super Integer> followingItemsConstraint) {
        if (null == followingItemsConstraint) {
            throw new NullPointerException();
        }
        this.requiredOffset = null;
        this.matchEndMatcher = followingItemsConstraint;
        this.reinitialize();
        return this;
    }

    ArrayPartMatcher(Object[] referenceSubarray) {
        if (null == referenceSubarray) {
            throw new NullPointerException();
        }
        this.referenceSubarray = referenceSubarray;
        this.referenceLength = referenceSubarray.length;
        this.reinitialize();
    }

    void reinitialize() {
        this.matcher = null != this.requiredOffset ? (this.requiredOffset >= 0 ? new FixedStartMatcher() : new FixedEndMatcher()) : new FullScanMatcher();
        assert (null != this.matcher);
        this.matcher.initialize();
    }

    protected boolean matchesSafely(Object[] array) {
        return this.matcher.match(array);
    }

    public void describeTo(Description description) {
        this.matcher.describe(description);
    }

    protected void describeMismatchSafely(Object[] array, Description mismatchDescription) {
        this.matcher.describeMismatch(array, mismatchDescription);
    }

    class FullScanMatcher
    implements MatcherImplementation {
        int offsetShift;

        FullScanMatcher() {
        }

        @Override
        public void initialize() {
            this.offsetShift = 1;
            if (ArrayPartMatcher.this.referenceLength > 1) {
                Object item;
                Object tailItem = ArrayPartMatcher.this.referenceSubarray[ArrayPartMatcher.this.referenceLength - 1];
                for (int idx = ArrayPartMatcher.this.referenceLength - 2; idx >= 0 && !Objects.equals(item = ArrayPartMatcher.this.referenceSubarray[idx], tailItem); --idx) {
                    ++this.offsetShift;
                }
            }
        }

        @Override
        public boolean match(Object[] testedArray) {
            int headLength;
            if (0 == ArrayPartMatcher.this.referenceLength) {
                return true;
            }
            if (testedArray.length < ArrayPartMatcher.this.referenceLength) {
                return false;
            }
            int tailIdx = headLength = ArrayPartMatcher.this.referenceLength - 1;
            Object tailItem = ArrayPartMatcher.this.referenceSubarray[tailIdx];
            while (tailIdx < testedArray.length) {
                int toCheck;
                Object item = testedArray[tailIdx];
                if (!Objects.equals(item, tailItem)) {
                    ++tailIdx;
                    continue;
                }
                int arrayOffset = tailIdx;
                for (toCheck = headLength; toCheck > 0 && Objects.equals(testedArray[--arrayOffset], ArrayPartMatcher.this.referenceSubarray[toCheck - 1]); --toCheck) {
                }
                if (0 == toCheck && this.isMatchValid(arrayOffset, testedArray)) {
                    return true;
                }
                tailIdx += this.offsetShift;
            }
            return false;
        }

        protected boolean isMatchValid(int startOffset, Object[] array) {
            boolean result;
            if (null != ArrayPartMatcher.this.matchStartMatcher && !ArrayPartMatcher.this.matchStartMatcher.matches((Object)startOffset)) {
                result = false;
            } else if (null != ArrayPartMatcher.this.matchEndMatcher) {
                int trailingItems = array.length - startOffset - ArrayPartMatcher.this.referenceLength;
                result = ArrayPartMatcher.this.matchEndMatcher.matches((Object)trailingItems);
            } else {
                result = true;
            }
            return result;
        }

        @Override
        public void describe(Description desc) {
            if (0 == ArrayPartMatcher.this.referenceLength) {
                desc.appendText("any array");
                return;
            }
            desc.appendText("array that contains ");
            desc.appendValueList("[", ", ", "]", ArrayPartMatcher.this.referenceSubarray);
            if (ArrayPartMatcher.this.referenceLength > 3) {
                desc.appendText(" of size " + ArrayPartMatcher.this.referenceLength);
            }
            String separator = "";
            if (null != ArrayPartMatcher.this.matchStartMatcher) {
                desc.appendText(" with start offset ");
                ArrayPartMatcher.this.matchStartMatcher.describeTo(desc);
                separator = " and";
            }
            if (null != ArrayPartMatcher.this.matchEndMatcher) {
                desc.appendText(separator);
                desc.appendText(" with number of following items ");
                ArrayPartMatcher.this.matchEndMatcher.describeTo(desc);
            }
        }

        @Override
        public void describeMismatch(Object[] testedArray, Description desc) {
            int headLength;
            assert (ArrayPartMatcher.this.referenceLength > 0);
            desc.appendText("array ");
            desc.appendValueList("[", ", ", "]", testedArray);
            int missingItems = ArrayPartMatcher.this.referenceLength - testedArray.length;
            if (missingItems > 0) {
                desc.appendText(" has insufficient length (missing " + missingItems);
                if (1 == missingItems) {
                    desc.appendText(" item)");
                } else {
                    desc.appendText(" items)");
                }
                return;
            }
            int tailIdx = headLength = ArrayPartMatcher.this.referenceLength - 1;
            Object tailItem = ArrayPartMatcher.this.referenceSubarray[tailIdx];
            int rawMatches = 0;
            while (tailIdx < testedArray.length) {
                int toCheck;
                Object item = testedArray[tailIdx];
                if (!Objects.equals(item, tailItem)) {
                    ++tailIdx;
                    continue;
                }
                int arrayOffset = tailIdx;
                for (toCheck = headLength; toCheck > 0 && Objects.equals(testedArray[--arrayOffset], ArrayPartMatcher.this.referenceSubarray[toCheck - 1]); --toCheck) {
                }
                if (0 == toCheck) {
                    assert (!this.isMatchValid(arrayOffset, testedArray));
                    ++rawMatches;
                }
                tailIdx += this.offsetShift;
            }
            if (0 == rawMatches) {
                desc.appendText(" does not contain the reference sub-array");
            } else {
                if (1 == rawMatches) {
                    desc.appendText(" contains a match, but ");
                } else {
                    desc.appendText(" contains " + rawMatches + " matches, but ");
                }
                String separator = "";
                String finalClause = " is not satisfied";
                if (null != ArrayPartMatcher.this.matchStartMatcher) {
                    if (null != ArrayPartMatcher.this.matchEndMatcher) {
                        desc.appendText("neither ");
                        separator = "nor ";
                        finalClause = " is satisfied";
                    }
                    desc.appendText("start offset constraint (");
                    ArrayPartMatcher.this.matchStartMatcher.describeTo(desc);
                    desc.appendText(")");
                }
                if (null != ArrayPartMatcher.this.matchEndMatcher) {
                    desc.appendText(separator);
                    desc.appendText("constraint for following item count (");
                    ArrayPartMatcher.this.matchEndMatcher.describeTo(desc);
                    desc.appendText(")");
                }
                desc.appendText(finalClause);
            }
        }
    }

    class FixedEndMatcher
    extends FixedStartMatcher {
        FixedEndMatcher() {
        }

        @Override
        public void initialize() {
            if (null == ArrayPartMatcher.this.requiredOffset) {
                throw new NullPointerException("Offset was not provided");
            }
            if (ArrayPartMatcher.this.requiredOffset >= 0) {
                throw new IllegalArgumentException("Offset must be negative: " + ArrayPartMatcher.this.requiredOffset);
            }
        }

        @Override
        protected int getStartIndex(Object[] testedArray) {
            int startOffset = testedArray.length - ArrayPartMatcher.this.referenceLength + ArrayPartMatcher.this.requiredOffset + 1;
            if (startOffset < 0) {
                startOffset = 0;
            }
            return startOffset;
        }

        @Override
        public void describe(Description desc) {
            if (-1 == ArrayPartMatcher.this.requiredOffset) {
                desc.appendText("array that ends with suffix ");
            } else {
                desc.appendText("array that contains ");
            }
            desc.appendValueList("[", ", ", "]", ArrayPartMatcher.this.referenceSubarray);
            if (ArrayPartMatcher.this.referenceLength > 3) {
                desc.appendText(" of size " + ArrayPartMatcher.this.referenceLength);
            }
            if (-1 != ArrayPartMatcher.this.requiredOffset) {
                int trailingItems = -ArrayPartMatcher.this.requiredOffset.intValue() - 1;
                desc.appendText(" with " + trailingItems + " following");
            }
        }
    }

    class FixedStartMatcher
    implements MatcherImplementation {
        FixedStartMatcher() {
        }

        @Override
        public void initialize() {
            if (null == ArrayPartMatcher.this.requiredOffset) {
                throw new NullPointerException("Offset was not provided");
            }
            if (ArrayPartMatcher.this.requiredOffset < 0) {
                throw new IllegalArgumentException("Offset must be positive: " + ArrayPartMatcher.this.requiredOffset);
            }
        }

        protected int getStartIndex(Object[] testedArray) {
            return ArrayPartMatcher.this.requiredOffset;
        }

        @Override
        public boolean match(Object[] testedArray) {
            int startOffset = this.getStartIndex(testedArray);
            if (startOffset + ArrayPartMatcher.this.referenceLength > testedArray.length) {
                return false;
            }
            int testIdx = startOffset;
            Object[] objectArray = ArrayPartMatcher.this.referenceSubarray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object testItem = testedArray[testIdx];
                Object refItem = objectArray[i];
                if (!Objects.equals(testItem, refItem)) {
                    return false;
                }
                ++testIdx;
            }
            return true;
        }

        @Override
        public void describe(Description desc) {
            if (0 == ArrayPartMatcher.this.requiredOffset) {
                desc.appendText("array that starts with prefix ");
            } else {
                desc.appendText("array that contains ");
            }
            desc.appendValueList("[", ", ", "]", ArrayPartMatcher.this.referenceSubarray);
            if (ArrayPartMatcher.this.referenceLength > 3) {
                desc.appendText(" of size " + ArrayPartMatcher.this.referenceLength);
            }
            if (0 != ArrayPartMatcher.this.requiredOffset) {
                desc.appendText(" starting at offset " + ArrayPartMatcher.this.requiredOffset);
            }
        }

        @Override
        public void describeMismatch(Object[] testedArray, Description desc) {
            desc.appendText("array ");
            desc.appendValueList("[", ", ", "]", testedArray);
            int startOffset = this.getStartIndex(testedArray);
            int missingItems = startOffset + ArrayPartMatcher.this.referenceLength - testedArray.length;
            if (missingItems > 0) {
                desc.appendText(" has insufficient length (missing " + missingItems + " items)");
                return;
            }
            ArrayList<Integer> mismatchGroupOffsets = null;
            boolean mismatchGroupOpen = false;
            int testIdx = startOffset - 1;
            for (Object refItem : ArrayPartMatcher.this.referenceSubarray) {
                Object testItem;
                if (Objects.equals(testItem = testedArray[++testIdx], refItem)) {
                    if (!mismatchGroupOpen) continue;
                    mismatchGroupOpen = false;
                    assert (1 == (mismatchGroupOffsets.size() & 1));
                    mismatchGroupOffsets.add(testIdx - 1);
                    continue;
                }
                if (mismatchGroupOpen) continue;
                mismatchGroupOpen = true;
                if (null == mismatchGroupOffsets) {
                    mismatchGroupOffsets = new ArrayList<Integer>(8);
                }
                assert (0 == (mismatchGroupOffsets.size() & 1));
                mismatchGroupOffsets.add(testIdx);
            }
            assert (null != mismatchGroupOffsets);
            if (mismatchGroupOpen) {
                assert (1 == (mismatchGroupOffsets.size() & 1));
                mismatchGroupOffsets.add(testIdx);
            }
            desc.appendText(" ");
            this.appendMismatchGroups((List<Integer>)mismatchGroupOffsets, desc);
        }

        void appendMismatchGroups(List<Integer> mismatchGroupOffsets, Description desc) {
            assert (0 == (mismatchGroupOffsets.size() & 1));
            int mismatchGroups = mismatchGroupOffsets.size() / 2;
            int firstStart = mismatchGroupOffsets.get(0);
            int firstEnd = mismatchGroupOffsets.get(1);
            if (1 == mismatchGroups) {
                desc.appendText("contains mismatch ");
                if (firstStart == firstEnd) {
                    desc.appendText("at offset " + firstStart);
                } else {
                    desc.appendText("block at offsets " + firstStart + '-' + firstEnd);
                }
            } else {
                desc.appendText("contains " + mismatchGroups + " mismatching blocks, first ");
                if (firstStart == firstEnd) {
                    desc.appendText("at offset " + firstStart);
                } else {
                    desc.appendText("at offsets " + firstStart + '-' + firstEnd);
                }
            }
        }
    }

    static interface MatcherImplementation {
        public void initialize();

        public boolean match(Object[] var1);

        public void describe(Description var1);

        public void describeMismatch(Object[] var1, Description var2);
    }
}

