/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.log;

import cz.auderis.test.logging.LogLevel;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class LogLevelMatcher
extends TypeSafeMatcher<LogLevel> {
    private final Set<LogLevel> matchingLevels;

    public LogLevelMatcher(Collection<LogLevel> levels) {
        super(LogLevel.class);
        if (null == levels || levels.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.matchingLevels = EnumSet.copyOf(levels);
    }

    protected boolean matchesSafely(LogLevel item) {
        return this.matchingLevels.contains((Object)item);
    }

    public void describeTo(Description description) {
        if (this.matchingLevels.size() == 1) {
            LogLevel singleLevel = this.matchingLevels.iterator().next();
            description.appendText("log level ").appendValue((Object)singleLevel);
        } else {
            description.appendText("one of log levels ");
            description.appendValueList("", ", ", "", this.matchingLevels);
        }
    }

    protected void describeMismatchSafely(LogLevel item, Description mismatchDescription) {
        mismatchDescription.appendText("logging level ").appendValue((Object)item);
    }

    @Factory
    public static Matcher<? super LogLevel> atLeast(LogLevel threshold) {
        return new LogLevelMatcher(threshold.plusHigherLevels());
    }

    @Factory
    public static Matcher<? super LogLevel> higherThan(LogLevel threshold) {
        return new LogLevelMatcher(threshold.getHigherLevels());
    }

    @Factory
    public static Matcher<? super LogLevel> atMost(LogLevel threshold) {
        return new LogLevelMatcher(threshold.plusLowerLevels());
    }

    @Factory
    public static Matcher<? super LogLevel> lowerThan(LogLevel threshold) {
        return new LogLevelMatcher(threshold.getLowerLevels());
    }

    @Factory
    public static Matcher<? super LogLevel> between(LogLevel lowLevel, LogLevel highLevel) {
        EnumSet<LogLevel> range = lowLevel.compareTo(highLevel) <= 0 ? EnumSet.range(lowLevel, highLevel) : EnumSet.range(highLevel, lowLevel);
        return new LogLevelMatcher(range);
    }
}

