/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.multi;

import cz.auderis.test.matcher.multi.PropertyEntry;
import cz.auderis.test.matcher.multi.PropertyExtractor;
import cz.auderis.test.support.DescriptionProvider;
import cz.auderis.test.support.MismatchDescriptionProvider;
import cz.auderis.test.support.NaturalDescriptionJoiner;
import org.hamcrest.Matcher;

final class PropMatcherEntry
implements PropertyEntry {
    final Matcher<Object> matcher;
    final PropertyExtractor extractor;
    Object descPrefix;
    Object descSuffix;
    DescriptionProvider<Matcher<?>> valueDescriber;
    MismatchDescriptionProvider<Object> mismatchDescriber;

    PropMatcherEntry(Matcher<Object> matcher, PropertyExtractor extractor, Object descPrefix, Object descSuffix) {
        assert (null != matcher);
        assert (null != extractor);
        this.matcher = matcher;
        this.extractor = extractor;
        this.descPrefix = descPrefix;
        this.descSuffix = descSuffix;
    }

    @Override
    public PropertyEntry withPrefix(Object prefix) {
        this.descPrefix = prefix;
        return this;
    }

    @Override
    public PropertyEntry withSuffix(Object suffix) {
        this.descSuffix = suffix;
        return this;
    }

    @Override
    public PropertyEntry withMatcherDescriber(DescriptionProvider<Matcher<?>> describer) {
        this.valueDescriber = describer;
        return this;
    }

    @Override
    public PropertyEntry withMismatchDescriber(MismatchDescriptionProvider<?> describer) {
        this.mismatchDescriber = describer;
        return this;
    }

    boolean matches(Object obj) {
        Object property = this.extractor.extract(obj);
        return this.matcher.matches(property);
    }

    void addToJoiner(NaturalDescriptionJoiner joiner) {
        joiner.add(this.descPrefix, this.matcher, this.descSuffix, this.valueDescriber);
    }

    void addMismatchToJoiner(Object obj, NaturalDescriptionJoiner joiner) {
        Object property = this.extractor.extract(obj);
        if (!this.matcher.matches(property)) {
            joiner.addMismatch(this.descPrefix, this.matcher, property, this.descSuffix, this.mismatchDescriber);
        }
    }
}

