/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.rawarray;

import cz.auderis.test.matcher.rawarray.IsByteArrayContainingMatcher;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class IsByteBufferContainingMatcher
extends TypeSafeMatcher<ByteBuffer> {
    private final byte[] expectedData;

    public IsByteBufferContainingMatcher(byte[] expectedData) {
        super(ByteBuffer.class);
        if (null == expectedData) {
            throw new NullPointerException();
        }
        this.expectedData = 0 == expectedData.length ? expectedData : Arrays.copyOf(expectedData, expectedData.length);
    }

    public IsByteBufferContainingMatcher(int ... intValues) {
        super(ByteBuffer.class);
        this.expectedData = new byte[intValues.length];
        for (int i = 0; i < intValues.length; ++i) {
            this.expectedData[i] = (byte)intValues[i];
        }
    }

    public IsByteBufferContainingMatcher(ByteBuffer reference) {
        super(ByteBuffer.class);
        if (null == reference) {
            throw new NullPointerException();
        }
        ByteBuffer refWindow = reference.slice();
        this.expectedData = new byte[refWindow.remaining()];
        if (refWindow.hasRemaining()) {
            refWindow.get(this.expectedData);
        }
    }

    protected boolean matchesSafely(ByteBuffer buffer) {
        if (this.expectedData.length != buffer.remaining()) {
            return false;
        }
        ByteBuffer bufferView = buffer.asReadOnlyBuffer();
        for (byte x : this.expectedData) {
            if (bufferView.get() == x) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        if (0 == this.expectedData.length) {
            description.appendText("empty byte buffer");
        } else {
            description.appendText("byte buffer with available " + this.expectedData.length + " bytes");
            description.appendText(" containing ");
            description.appendText(IsByteArrayContainingMatcher.formatByteArray(this.expectedData, null).toString());
        }
    }

    protected void describeMismatchSafely(ByteBuffer buffer, Description out) {
        ByteBuffer bufferView = buffer.asReadOnlyBuffer();
        int size = bufferView.remaining();
        if (size != this.expectedData.length) {
            out.appendText("buffer available data size was " + size);
        } else {
            byte[] bufferBytes = new byte[size];
            bufferView.get(bufferBytes);
            out.appendText("was ").appendText(IsByteArrayContainingMatcher.formatByteArray(bufferBytes, this.expectedData).toString());
        }
    }
}

