/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.logging.jboss;

import cz.auderis.test.logging.LogCaptureInitializer;
import cz.auderis.test.logging.jboss.JBossLoggerProvider;
import java.lang.reflect.Field;

public class JBossLoggingInitializer
implements LogCaptureInitializer {
    private static boolean INITIALIZED = false;

    @Override
    public boolean isFrameworkPresent() {
        try {
            Class<?> frameworkClass = Class.forName("org.jboss.logging.LoggerProviders");
            assert (null != frameworkClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws Exception {
        Class<JBossLoggingInitializer> clazz = JBossLoggingInitializer.class;
        synchronized (JBossLoggingInitializer.class) {
            Field modifiersField;
            if (INITIALIZED) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot intercept JBoss Logging framework", e);
            }
            try {
                Class<?> providerClass = Class.forName("org.jboss.logging.LoggerProviders");
                Field providerField = providerClass.getDeclaredField("PROVIDER");
                providerField.setAccessible(true);
                modifiersField.setInt(providerField, providerField.getModifiers() & 0xFFFFFFEF);
                providerField.set(null, JBossLoggerProvider.INSTANCE);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("JBoss Logging framework not detected");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Unsupported version of JBoss Logging framework");
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to intercept JBoss Logging provider", e);
            }
            finally {
                INITIALIZED = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

