/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.date;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateHelper {
    static final String DATE_ISO_FORMAT = "yyyy-MM-dd";
    static final String FULL_ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    static final Pattern FULL_ISO_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}([T ])\\d{2}:\\d{2}:\\d{2}((?:\\.\\d{3})?)");
    static final Pattern COMPACT_ISO_PATTERN = Pattern.compile("\\d{4}(-?)\\d{2}\\1\\d{2}([T ]?)\\d{2}(:?)\\d{2}\\3\\d{2}");
    static final Pattern DATE_ISO_PATTERN = Pattern.compile("\\d{4}(-?)\\d{2}\\1\\d{2}");
    static final List<Integer> TIME_UNIT_FIELDS;
    static final Map<Integer, String> DATE_FIELDS;
    static final Map<Integer, String> TIME_FIELDS;

    public static String formatDate(int leastFieldUnit, Date d) {
        SimpleDateFormat format;
        assert (null != d);
        if (DATE_FIELDS.containsKey(leastFieldUnit)) {
            format = new SimpleDateFormat(DATE_ISO_FORMAT);
        } else {
            assert (TIME_FIELDS.containsKey(leastFieldUnit));
            format = new SimpleDateFormat(FULL_ISO_FORMAT);
        }
        return format.format(d);
    }

    public static String[] formatDates(int leastFieldUnit, Object ... dates) {
        SimpleDateFormat format;
        assert (null != dates && dates.length > 0);
        if (DATE_FIELDS.containsKey(leastFieldUnit)) {
            format = new SimpleDateFormat(DATE_ISO_FORMAT);
        } else {
            assert (TIME_FIELDS.containsKey(leastFieldUnit));
            format = new SimpleDateFormat(FULL_ISO_FORMAT);
        }
        String[] result = new String[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            Date date;
            Object arg = dates[i];
            if (null == arg) {
                result[i] = null;
                continue;
            }
            if (arg instanceof Date) {
                date = (Date)arg;
            } else if (arg instanceof Calendar) {
                date = ((Calendar)arg).getTime();
            } else {
                throw new IllegalArgumentException("bad argument " + i);
            }
            result[i] = format.format(date);
        }
        return result;
    }

    public static String getUnitName(int unitField) {
        if (DATE_FIELDS.containsKey(unitField)) {
            return DATE_FIELDS.get(unitField);
        }
        if (TIME_FIELDS.containsKey(unitField)) {
            return TIME_FIELDS.get(unitField);
        }
        throw new IllegalArgumentException("unsupported calendar field");
    }

    public static Date parseDateAllowingNull(String dateText) {
        return DateHelper.parseDateAllowingNull(dateText, null);
    }

    public static Date parseDateAllowingNull(String dateText, String optionalCustomFormat) {
        if (null == dateText || dateText.trim().isEmpty()) {
            return null;
        }
        return DateHelper.parseDate(dateText, optionalCustomFormat);
    }

    public static Date parseDate(String dateText) {
        return DateHelper.parseDate(dateText, null);
    }

    public static Date parseDate(String dateText, String optionalCustomFormat) {
        if (null == dateText) {
            throw new NullPointerException();
        }
        if (dateText.trim().isEmpty()) {
            return null;
        }
        DateFormat format = DateHelper.determineDatePattern(dateText, optionalCustomFormat);
        try {
            return format.parse(dateText);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse date '" + dateText + "'", e);
        }
    }

    public static List<Integer> majorFieldUnits(int leastMajorUnit) {
        int leastUnitIndex = TIME_UNIT_FIELDS.indexOf(leastMajorUnit);
        assert (leastUnitIndex >= 0);
        List<Integer> majorFields = TIME_UNIT_FIELDS.subList(0, leastUnitIndex + 1);
        return majorFields;
    }

    public static List<Integer> minorFieldUnits(int leastMajorUnit) {
        int leastUnitIndex = TIME_UNIT_FIELDS.indexOf(leastMajorUnit);
        assert (leastUnitIndex >= 0);
        int allFieldCount = TIME_UNIT_FIELDS.size();
        if (leastUnitIndex == allFieldCount - 1) {
            return Collections.emptyList();
        }
        List<Integer> minorFields = TIME_UNIT_FIELDS.subList(leastUnitIndex + 1, allFieldCount);
        return minorFields;
    }

    public static void setMinorFieldValues(Calendar targetCal, int ... fieldValues) {
        int allFieldCount = TIME_UNIT_FIELDS.size();
        assert (0 < fieldValues.length && fieldValues.length <= allFieldCount);
        ListIterator<Integer> fieldIterator = TIME_UNIT_FIELDS.listIterator(allFieldCount - fieldValues.length);
        for (int fieldValue : fieldValues) {
            assert (fieldIterator.hasNext());
            int minorField = (Integer)fieldIterator.next();
            targetCal.set(minorField, fieldValue);
        }
    }

    public static void resetMinorFieldsToMinimum(Calendar targetCal, int leastMajorUnit) {
        for (Integer minorUnit : DateHelper.minorFieldUnits(leastMajorUnit)) {
            int minValue = targetCal.getActualMinimum(minorUnit);
            targetCal.set(minorUnit, minValue);
        }
    }

    public static void resetMinorFieldsToMaximum(Calendar targetCal, int leastMajorUnit) {
        for (Integer minorUnit : DateHelper.minorFieldUnits(leastMajorUnit)) {
            int maxValue = targetCal.getActualMaximum(minorUnit);
            targetCal.set(minorUnit, maxValue);
        }
    }

    public static DateFormat determineDatePattern(String textParam, String options) {
        DateFormat format = null != options && !options.trim().isEmpty() ? new SimpleDateFormat(options) : DateHelper.recognizeStandardDatePattern(textParam);
        return format;
    }

    private static DateFormat recognizeStandardDatePattern(String textParam) {
        StringBuilder formatBuilder = new StringBuilder(32);
        Matcher matcher = FULL_ISO_PATTERN.matcher(textParam);
        if (matcher.matches()) {
            formatBuilder.append(DATE_ISO_FORMAT);
            String dateTimeSeparator = matcher.group(1);
            formatBuilder.append('\'').append(dateTimeSeparator).append('\'');
            formatBuilder.append("HH:mm:ss");
            String millisPart = matcher.group(2);
            if (null != millisPart && !millisPart.isEmpty()) {
                formatBuilder.append(".SSS");
            }
            return new SimpleDateFormat(formatBuilder.toString());
        }
        matcher.usePattern(COMPACT_ISO_PATTERN).reset();
        if (matcher.matches()) {
            String datePartSeparator = matcher.group(1);
            formatBuilder.append("yyyy");
            formatBuilder.append(datePartSeparator).append("MM");
            formatBuilder.append(datePartSeparator).append("dd");
            String dateTimeSeparator = matcher.group(2);
            if (!dateTimeSeparator.isEmpty()) {
                formatBuilder.append('\'').append(dateTimeSeparator).append('\'');
            }
            String timePartSeparator = matcher.group(3);
            formatBuilder.append("HH");
            formatBuilder.append(timePartSeparator).append("mm");
            formatBuilder.append(timePartSeparator).append("ss");
            return new SimpleDateFormat(formatBuilder.toString());
        }
        matcher.usePattern(DATE_ISO_PATTERN).reset();
        if (matcher.matches()) {
            String datePartSeparator = matcher.group(1);
            formatBuilder.append("yyyy");
            formatBuilder.append(datePartSeparator).append("MM");
            formatBuilder.append(datePartSeparator).append("dd");
            return new SimpleDateFormat(formatBuilder.toString());
        }
        throw new IllegalArgumentException("Cannot determine date format of '" + textParam + "'");
    }

    private DateHelper() {
        throw new AssertionError();
    }

    static {
        List<Integer> fieldList = Arrays.asList(1, 2, 5, 11, 12, 13, 14);
        TIME_UNIT_FIELDS = Collections.unmodifiableList(fieldList);
        LinkedHashMap<Integer, String> dateMap = new LinkedHashMap<Integer, String>(3);
        dateMap.put(1, "year");
        dateMap.put(2, "month");
        dateMap.put(5, "day");
        DATE_FIELDS = Collections.unmodifiableMap(dateMap);
        LinkedHashMap<Integer, String> timeMap = new LinkedHashMap<Integer, String>(4);
        timeMap.put(11, "hour");
        timeMap.put(12, "minute");
        timeMap.put(13, "second");
        timeMap.put(14, "millisecond");
        TIME_FIELDS = Collections.unmodifiableMap(timeMap);
    }
}

