/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.numeric;

import java.math.BigDecimal;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class BigDecPropertyMatcher
extends TypeSafeMatcher<BigDecimal> {
    private final Matcher<? super Integer> precisionMatcher;
    private final Matcher<? super Integer> scaleMatcher;
    private final boolean useNormalizedPrecision;
    private final boolean useNormalizedScale;

    public BigDecPropertyMatcher(Matcher<? super Integer> precisionMatcher, Matcher<? super Integer> scaleMatcher, boolean normalizedPrecision, boolean normalizedScale) {
        super(BigDecimal.class);
        this.precisionMatcher = precisionMatcher;
        this.scaleMatcher = scaleMatcher;
        this.useNormalizedPrecision = normalizedPrecision;
        this.useNormalizedScale = normalizedScale;
    }

    protected boolean matchesSafely(BigDecimal num) {
        if (null != this.precisionMatcher && !this.precisionMatcher.matches((Object)this.getPrecision(num))) {
            return false;
        }
        return null == this.scaleMatcher || this.scaleMatcher.matches((Object)this.getScale(num));
    }

    public void describeTo(Description description) {
        description.appendText("decimal number");
        String separator = " with ";
        if (null != this.precisionMatcher) {
            description.appendText(separator);
            separator = " and ";
            if (this.useNormalizedPrecision) {
                description.appendText("normalized ");
            }
            description.appendText("precision that ");
            description.appendDescriptionOf(this.precisionMatcher);
        }
        if (null != this.scaleMatcher) {
            description.appendText(separator);
            if (this.useNormalizedScale) {
                description.appendText("normalized ");
            }
            description.appendText("scale that ");
            description.appendDescriptionOf(this.scaleMatcher);
        }
    }

    protected void describeMismatchSafely(BigDecimal num, Description out) {
        out.appendText("was decimal number ");
        out.appendValue((Object)num);
        String separator = " with ";
        if (null != this.precisionMatcher && !this.precisionMatcher.matches((Object)this.getPrecision(num))) {
            out.appendText(separator);
            separator = " and with ";
            if (this.useNormalizedPrecision) {
                out.appendText("normalized ");
            }
            out.appendText("precision that ");
            this.precisionMatcher.describeMismatch((Object)this.getPrecision(num), out);
        }
        if (null != this.scaleMatcher && !this.scaleMatcher.matches((Object)this.getScale(num))) {
            out.appendText(separator);
            if (this.useNormalizedScale) {
                out.appendText("normalized ");
            }
            out.appendText("scale that ");
            this.scaleMatcher.describeMismatch((Object)this.getScale(num), out);
        }
    }

    private int getPrecision(BigDecimal num) {
        if (this.useNormalizedPrecision) {
            return num.stripTrailingZeros().precision();
        }
        return num.precision();
    }

    private int getScale(BigDecimal num) {
        if (this.useNormalizedScale) {
            return num.stripTrailingZeros().scale();
        }
        return num.scale();
    }
}

