/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.parameter.annotation.impl;

import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class HexChunkParser {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private static final Pattern HEX_CHUNK_PATTERN = Pattern.compile("(?:\\{.*?\\}\\s*+)?+(?:(?:0x([0-9A-F]++))|([0-9A-F]{2,}+|[1-9A-F]|0(?!x))(?:H)?)", 2);
    private final Matcher hexChunkMatcher;
    private final boolean useDirectBuffer;
    private ByteBuffer resultBuffer;

    HexChunkParser() {
        this(false);
    }

    HexChunkParser(boolean useDirectBuffer) {
        this.useDirectBuffer = useDirectBuffer;
        this.hexChunkMatcher = HEX_CHUNK_PATTERN.matcher("");
    }

    byte[] parseByteArray(Object dataSpec) {
        if (null == dataSpec) {
            return EMPTY_ARRAY;
        }
        if (dataSpec instanceof byte[]) {
            return (byte[])dataSpec;
        }
        this.hexChunkMatcher.reset(dataSpec.toString());
        int totalBytes = this.countBytes();
        if (0 == totalBytes) {
            return EMPTY_ARRAY;
        }
        byte[] result = new byte[totalBytes];
        this.resultBuffer = ByteBuffer.wrap(result);
        this.parseChunks();
        return result;
    }

    ByteBuffer parseBuffer(Object dataSpec) {
        if (null == dataSpec) {
            return this.newBuffer(0);
        }
        if (dataSpec instanceof ByteBuffer) {
            ByteBuffer result;
            ByteBuffer paramBuffer = (ByteBuffer)dataSpec;
            if (this.useDirectBuffer == paramBuffer.isDirect()) {
                result = paramBuffer;
            } else {
                ByteBuffer copySource = paramBuffer.asReadOnlyBuffer();
                result = this.newBuffer(copySource.capacity());
                copySource.clear();
                result.put(copySource);
                result.limit(paramBuffer.limit());
                result.position(paramBuffer.position());
            }
            return result;
        }
        this.hexChunkMatcher.reset(dataSpec.toString());
        int totalBytes = this.countBytes();
        if (0 == totalBytes) {
            return this.newBuffer(0);
        }
        this.resultBuffer = this.newBuffer(totalBytes);
        this.parseChunks();
        this.resultBuffer.flip();
        return this.resultBuffer;
    }

    private int countBytes() {
        int totalBytes = 0;
        while (this.hexChunkMatcher.find()) {
            String suffixedChunk;
            String prefixedChunk = this.hexChunkMatcher.group(1);
            if (null != prefixedChunk) {
                totalBytes += (prefixedChunk.length() + 1) / 2;
            }
            if (null == (suffixedChunk = this.hexChunkMatcher.group(2))) continue;
            totalBytes += (suffixedChunk.length() + 1) / 2;
        }
        return totalBytes;
    }

    private void parseChunks() {
        this.hexChunkMatcher.reset();
        while (this.hexChunkMatcher.find()) {
            String prefixedChunk = this.hexChunkMatcher.group(1);
            this.appendChunk(prefixedChunk);
            String suffixedChunk = this.hexChunkMatcher.group(2);
            this.appendChunk(suffixedChunk);
        }
    }

    private void appendChunk(String hexChunk) {
        if (null == hexChunk) {
            return;
        }
        int chunkSize = hexChunk.length();
        boolean byteEnd = 1 == (chunkSize & 1);
        int prevDigit = 0;
        for (int pos = 0; pos < chunkSize; ++pos) {
            char c = hexChunk.charAt(pos);
            int hexDigit = Character.digit(c, 16);
            if (byteEnd) {
                int byteValue = prevDigit << 4 | hexDigit;
                this.resultBuffer.put((byte)byteValue);
            } else {
                prevDigit = hexDigit;
            }
            byteEnd = !byteEnd;
        }
    }

    private ByteBuffer newBuffer(int size) {
        if (this.useDirectBuffer) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }
}

