/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.rule;

import cz.auderis.test.logging.AbstractLogLevelConfiguration;
import cz.auderis.test.logging.LogLevel;
import cz.auderis.test.logging.LogLevelConfiguration;
import cz.auderis.test.logging.LogRecord;
import cz.auderis.test.logging.LogRecordCollector;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class LogBuffer
extends TestWatcher {
    private final Set<LogLevel> enabledLevels = EnumSet.allOf(LogLevel.class);
    private LogLevel failureLogDumpThreshold;
    private LogLevel successLogDumpThreshold;

    public LogLevelConfiguration levels() {
        return new LogLevelConfigurationImpl();
    }

    public LogLevel getSuccessLogDumpThreshold() {
        return this.successLogDumpThreshold;
    }

    public void setSuccessLogDumpThreshold(LogLevel successLogDumpThreshold) {
        this.successLogDumpThreshold = successLogDumpThreshold;
    }

    public void dumpOnSuccess() {
        this.successLogDumpThreshold = LogLevel.INFO;
    }

    public void dumpOnSuccess(LogLevel threshold) {
        this.successLogDumpThreshold = threshold;
    }

    public LogLevel getFailureLogDumpThreshold() {
        return this.failureLogDumpThreshold;
    }

    public void setFailureLogDumpThreshold(LogLevel failureLogDumpThreshold) {
        this.failureLogDumpThreshold = failureLogDumpThreshold;
    }

    public void dumpOnFailure() {
        this.failureLogDumpThreshold = LogLevel.INFO;
    }

    public void dumpOnFailure(LogLevel threshold) {
        this.failureLogDumpThreshold = threshold;
    }

    public List<LogRecord> getRecords() {
        LogRecordCollector collector = LogRecordCollector.RECORD_COLLECTOR;
        return new ArrayList<LogRecord>(collector.getRecords());
    }

    public List<LogRecord> getRecords(Matcher<? super LogRecord> recordMatcher) {
        LogRecordCollector collector = LogRecordCollector.RECORD_COLLECTOR;
        List<LogRecord> allRecords = collector.getRecords();
        ArrayList<LogRecord> result = new ArrayList<LogRecord>(allRecords.size());
        if (null == recordMatcher || allRecords.isEmpty()) {
            result.addAll(allRecords);
        } else {
            for (LogRecord record : allRecords) {
                if (!recordMatcher.matches((Object)record)) continue;
                result.add(record);
            }
        }
        return result;
    }

    protected void starting(Description description) {
        this.resetLogging();
    }

    protected void failed(Throwable e, Description description) {
        this.dumpLog(this.failureLogDumpThreshold);
    }

    protected void succeeded(Description description) {
        this.dumpLog(this.successLogDumpThreshold);
    }

    private void resetLogging() {
        LogRecordCollector collector = LogRecordCollector.RECORD_COLLECTOR;
        collector.reset();
        this.enabledLevels.clear();
        this.enabledLevels.addAll(collector.getEnabledLevels());
    }

    private void dumpLog(LogLevel threshold) {
        if (null == threshold) {
            return;
        }
        LogRecordCollector collector = LogRecordCollector.RECORD_COLLECTOR;
        collector.dump(System.out, threshold);
    }

    private class LogLevelConfigurationImpl
    extends AbstractLogLevelConfiguration {
        private LogLevelConfigurationImpl() {
        }

        @Override
        protected Set<LogLevel> getLevelSet() {
            return LogBuffer.this.enabledLevels;
        }

        @Override
        protected void levelSetChanged() {
            super.levelSetChanged();
            LogRecordCollector.RECORD_COLLECTOR.setEnabledLevels(LogBuffer.this.enabledLevels);
        }
    }
}

