/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.rule;

import cz.auderis.test.logging.LogCaptureInitializer;
import cz.auderis.test.logging.LogRecordCollector;
import cz.auderis.test.logging.jboss.JBossLoggingInitializer;
import cz.auderis.test.logging.log4j.Log4jInitializer;
import cz.auderis.test.logging.slf4j.Slf4jInitializer;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LogFramework
implements TestRule {
    private final Set<Flavour> loggingFlavours;

    public static LogFramework everything() {
        return new LogFramework(EnumSet.allOf(Flavour.class));
    }

    public static LogFramework slf4j() {
        return new LogFramework(Flavour.SLF4J);
    }

    public static LogFramework jboss() {
        return new LogFramework(Flavour.JBOSS);
    }

    public static LogFramework log4j() {
        return new LogFramework(Flavour.LOG4J);
    }

    public LogFramework andSlf4j() {
        this.loggingFlavours.add(Flavour.SLF4J);
        return this;
    }

    public LogFramework andJboss() {
        this.loggingFlavours.add(Flavour.JBOSS);
        return this;
    }

    public LogFramework andLog4j() {
        this.loggingFlavours.add(Flavour.LOG4J);
        return this;
    }

    private LogFramework(Flavour loggingFlavour) {
        this.loggingFlavours = EnumSet.of(loggingFlavour);
    }

    private LogFramework(EnumSet<Flavour> flavours) {
        this.loggingFlavours = flavours;
    }

    public Statement apply(final Statement base, Description description) {
        boolean captureInitialized = this.initializeLogFrameworks();
        if (!captureInitialized) {
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                LogRecordCollector.RECORD_COLLECTOR.reset();
                base.evaluate();
            }
        };
    }

    private boolean initializeLogFrameworks() {
        EnumSet<Flavour> presentFrameworks = EnumSet.copyOf(this.loggingFlavours);
        Iterator iter = presentFrameworks.iterator();
        while (iter.hasNext()) {
            Flavour flavour = (Flavour)((Object)iter.next());
            LogCaptureInitializer initializer = flavour.getInitializer();
            if (initializer.isFrameworkPresent()) {
                try {
                    initializer.initialize();
                }
                catch (Throwable e) {
                    iter.remove();
                }
                continue;
            }
            iter.remove();
        }
        return !presentFrameworks.isEmpty();
    }

    private static enum Flavour {
        SLF4J{

            @Override
            LogCaptureInitializer getInitializer() {
                return new Slf4jInitializer();
            }
        }
        ,
        JBOSS{

            @Override
            LogCaptureInitializer getInitializer() {
                return new JBossLoggingInitializer();
            }
        }
        ,
        LOG4J{

            @Override
            LogCaptureInitializer getInitializer() {
                return new Log4jInitializer();
            }
        };


        abstract LogCaptureInitializer getInitializer();
    }
}

