/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.support;

import cz.auderis.test.support.DescriptionProvider;
import cz.auderis.test.support.MismatchDescriptionProvider;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public class NaturalDescriptionJoiner
implements SelfDescribing {
    Object prefix;
    Object suffix;
    Object normalSeparator;
    Object lastSeparator;
    boolean usePrefixWhenEmpty;
    boolean useSuffixWhenEmpty;
    final List<DescriptionItem> items;

    public NaturalDescriptionJoiner(Object prefix, Object normalSeparator, Object lastSeparator, Object suffix) {
        this.prefix = prefix;
        this.normalSeparator = null != normalSeparator ? normalSeparator : "";
        this.lastSeparator = null != lastSeparator ? lastSeparator : "";
        this.suffix = suffix;
        this.items = new LinkedList<DescriptionItem>();
    }

    public NaturalDescriptionJoiner() {
        this(null, ", ", " and ", null);
    }

    public NaturalDescriptionJoiner(Object separator) {
        this(null, separator, separator, null);
    }

    public NaturalDescriptionJoiner(Object normalSeparator, Object lastSeparator) {
        this(null, normalSeparator, lastSeparator, null);
    }

    public NaturalDescriptionJoiner withPrefix(Object prefix) {
        this.prefix = prefix;
        return this;
    }

    public NaturalDescriptionJoiner withSuffix(Object suffix) {
        this.suffix = suffix;
        return this;
    }

    public NaturalDescriptionJoiner withNormalSeparator(Object normalSep) {
        this.normalSeparator = null != normalSep ? normalSep : "";
        return this;
    }

    public NaturalDescriptionJoiner withLastSeparator(Object lastSep) {
        this.lastSeparator = null != lastSep ? lastSep : "";
        return this;
    }

    public boolean isUsePrefixWhenEmpty() {
        return this.usePrefixWhenEmpty;
    }

    public void setUsePrefixWhenEmpty(boolean usePrefixWhenEmpty) {
        this.usePrefixWhenEmpty = usePrefixWhenEmpty;
    }

    public NaturalDescriptionJoiner withPrefixWhenEmpty() {
        this.usePrefixWhenEmpty = true;
        return this;
    }

    public NaturalDescriptionJoiner withoutPrefixWhenEmpty() {
        this.usePrefixWhenEmpty = false;
        return this;
    }

    public boolean isUseSuffixWhenEmpty() {
        return this.useSuffixWhenEmpty;
    }

    public void setUseSuffixWhenEmpty(boolean useSuffixWhenEmpty) {
        this.useSuffixWhenEmpty = useSuffixWhenEmpty;
    }

    public NaturalDescriptionJoiner withSuffixWhenEmpty() {
        this.useSuffixWhenEmpty = true;
        return this;
    }

    public NaturalDescriptionJoiner withoutSuffixWhenEmpty() {
        this.useSuffixWhenEmpty = false;
        return this;
    }

    public boolean isEmpty() {
        this.compactItems();
        return this.items.isEmpty();
    }

    public NaturalDescriptionJoiner add(Object valuePrefix, Object value, Object valueSuffix) {
        if (null != value) {
            DescriptionItem item = new DescriptionItem(valuePrefix, value, valueSuffix);
            this.items.add(item);
        }
        return this;
    }

    public NaturalDescriptionJoiner add(Object valuePrefix, Object value) {
        return this.add(valuePrefix, value, null);
    }

    public NaturalDescriptionJoiner add(Object value) {
        return this.add(null, value, null);
    }

    public <T> NaturalDescriptionJoiner add(Object valuePrefix, T value, Object valueSuffix, DescriptionProvider<? super T> valueDescriber) {
        if (null != value) {
            DescriptionItem item = new DescriptionItem(valuePrefix, value, valueSuffix, valueDescriber);
            this.items.add(item);
        }
        return this;
    }

    public <T> NaturalDescriptionJoiner addMismatch(Object valuePrefix, Matcher<? super T> valueMatcher, T value, Object valueSuffix) {
        if (null != valueMatcher && !valueMatcher.matches(value)) {
            DescriptionItem item = new DescriptionItem(valuePrefix, valueMatcher, value, valueSuffix);
            this.items.add(item);
        }
        return this;
    }

    public <T> NaturalDescriptionJoiner addMismatch(Object valuePrefix, Matcher<? super T> valueMatcher, T value) {
        return this.addMismatch(valuePrefix, valueMatcher, value, null);
    }

    public <T> NaturalDescriptionJoiner addMismatch(Matcher<? super T> valueMatcher, T value) {
        return this.addMismatch(null, valueMatcher, value, null);
    }

    public <T> NaturalDescriptionJoiner addMismatch(Object valuePrefix, Matcher<? super T> valueMatcher, T value, Object valueSuffix, MismatchDescriptionProvider<? super T> mismatchDescriber) {
        if (null != valueMatcher && !valueMatcher.matches(value)) {
            DescriptionItem item = new DescriptionItem(valuePrefix, valueMatcher, value, valueSuffix, mismatchDescriber);
            this.items.add(item);
        }
        return this;
    }

    public void describeTo(Description desc) {
        if (null == desc) {
            return;
        }
        this.compactItems();
        int itemCount = this.items.size();
        if (0 == itemCount && !this.usePrefixWhenEmpty && !this.useSuffixWhenEmpty) {
            return;
        }
        if (0 != itemCount || this.usePrefixWhenEmpty) {
            NaturalDescriptionJoiner.smartAppend(this.prefix, desc);
        }
        int idx = itemCount - 1;
        for (DescriptionItem item : this.items) {
            NaturalDescriptionJoiner.appendItemSurroundingTextToDescription(item.matcher, item.valuePrefix, desc);
            if (null != item.matcher) {
                item.describeMismatch(desc);
            } else {
                item.describeValue(desc);
            }
            NaturalDescriptionJoiner.appendItemSurroundingTextToDescription(item.matcher, item.valueSuffix, desc);
            if (1 == idx) {
                NaturalDescriptionJoiner.smartAppend(this.lastSeparator, desc);
            } else if (idx > 1) {
                NaturalDescriptionJoiner.smartAppend(this.normalSeparator, desc);
            }
            --idx;
        }
        if (0 != itemCount || this.useSuffixWhenEmpty) {
            NaturalDescriptionJoiner.smartAppend(this.suffix, desc);
        }
    }

    public void appendTo(StringBuilder sb) {
        if (null == sb) {
            return;
        }
        StringDescription desc = new StringDescription((Appendable)sb);
        this.describeTo((Description)desc);
    }

    private void compactItems() {
        Iterator<DescriptionItem> itemIterator = this.items.iterator();
        while (itemIterator.hasNext()) {
            DescriptionItem item = itemIterator.next();
            if (!item.isRedundant()) continue;
            itemIterator.remove();
        }
    }

    private static void appendItemSurroundingTextToDescription(Matcher<?> matcher, Object obj, Description desc) {
        if (null != matcher && obj instanceof MismatchDescriptionProvider) {
            ((MismatchDescriptionProvider)obj).describe(matcher, obj, desc);
        } else if (obj instanceof DescriptionProvider) {
            ((DescriptionProvider)obj).describe(obj, desc);
        } else {
            NaturalDescriptionJoiner.smartAppend(obj, desc);
        }
    }

    private static void smartAppend(Object obj, Description desc) {
        boolean reevaluate;
        Object result = obj;
        do {
            if (!(result instanceof Callable)) continue;
            try {
                result = ((Callable)result).call();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to obtain text for description", e);
            }
        } while (reevaluate = null != result && !(result instanceof CharSequence) && !(result instanceof SelfDescribing));
        if (null != result) {
            if (result instanceof SelfDescribing) {
                ((SelfDescribing)result).describeTo(desc);
            } else {
                desc.appendText(result.toString());
            }
        }
    }

    static final class DescriptionItem {
        final Object valuePrefix;
        final Object valueSuffix;
        final Object value;
        final Matcher<Object> matcher;
        final DescriptionProvider<Object> valueDescriptionProvider;
        final MismatchDescriptionProvider<Object> mismatchDescriptionProvider;
        final boolean usingMatcher;

        DescriptionItem(Object valuePrefix, Object value, Object valueSuffix) {
            this(valuePrefix, value, valueSuffix, null);
        }

        DescriptionItem(Object valuePrefix, Object value, Object valueSuffix, DescriptionProvider descriptionProvider) {
            this.valuePrefix = valuePrefix;
            this.value = value;
            this.valueSuffix = valueSuffix;
            this.valueDescriptionProvider = descriptionProvider;
            this.matcher = null;
            this.mismatchDescriptionProvider = null;
            this.usingMatcher = false;
        }

        DescriptionItem(Object valuePrefix, Matcher<?> matcher, Object value, Object valueSuffix) {
            this(valuePrefix, matcher, value, valueSuffix, null);
        }

        DescriptionItem(Object valuePrefix, Matcher<?> matcher, Object value, Object valueSuffix, MismatchDescriptionProvider<?> mismatchDescriptionProvider) {
            this.valuePrefix = valuePrefix;
            this.value = value;
            this.valueSuffix = valueSuffix;
            this.valueDescriptionProvider = null;
            this.matcher = matcher;
            this.mismatchDescriptionProvider = mismatchDescriptionProvider;
            this.usingMatcher = true;
        }

        boolean isRedundant() {
            boolean result = this.usingMatcher ? null == this.matcher || this.matcher.matches(this.value) : null == this.value;
            return result;
        }

        void describeValue(Description desc) {
            if (null != this.valueDescriptionProvider) {
                this.valueDescriptionProvider.describe(this.value, desc);
            } else if (this.value instanceof SelfDescribing) {
                ((SelfDescribing)this.value).describeTo(desc);
            } else {
                desc.appendText(String.valueOf(this.value));
            }
        }

        void describeMismatch(Description desc) {
            if (null != this.mismatchDescriptionProvider) {
                this.mismatchDescriptionProvider.describe(this.matcher, this.value, desc);
            } else if (null != this.matcher) {
                this.matcher.describeMismatch(this.value, desc);
            } else {
                desc.appendText("N/A");
            }
        }
    }
}

