/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.support.array;

import cz.auderis.test.support.array.ArrayItemFiller;
import cz.auderis.test.support.array.ArraySequenceParser;
import cz.auderis.test.support.array.BasicArraySequenceParsers;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;

public enum PrimitiveArrayItemSupport implements ArraySequenceParser,
ArrayItemFiller
{
    BOOLEAN((Class)Boolean.TYPE, (Class)Boolean.class){

        @Override
        public List<String> parseItems(String sourceText, int initialOffset, int expectedItemCount) {
            ArrayList<String> result = new ArrayList<String>(expectedItemCount);
            Scanner scanner = new Scanner(sourceText.substring(initialOffset));
            while (scanner.hasNext()) {
                boolean value;
                String token = scanner.next();
                if (BOOLEAN_TRUE_VALUES.contains(token)) {
                    value = true;
                } else if (BOOLEAN_FALSE_VALUES.contains(token)) {
                    value = false;
                } else if ("true".equalsIgnoreCase(token) || "yes".equalsIgnoreCase(token)) {
                    value = true;
                } else if ("false".equalsIgnoreCase(token) || "no".equalsIgnoreCase(token)) {
                    value = false;
                } else {
                    throw new IllegalArgumentException("Invalid array specification, bad boolean value '" + token + "': " + sourceText);
                }
                result.add(String.valueOf(value));
            }
            return result;
        }

        @Override
        public void setItem(Object target, int index, String itemSpec) {
            boolean value = Boolean.parseBoolean(itemSpec);
            Array.setBoolean(target, index, value);
        }
    }
    ,
    BYTE((Class)Byte.TYPE, (Class)Byte.class){

        @Override
        public List<String> parseItems(String sourceText, int initialOffset, int expectedItemCount) {
            ArrayList<String> result = new ArrayList<String>(expectedItemCount);
            try {
                Scanner scanner = new Scanner(sourceText.substring(initialOffset));
                while (scanner.hasNext()) {
                    byte num = scanner.nextByte();
                    result.add(String.valueOf(num));
                }
            }
            catch (InputMismatchException e) {
                throw new IllegalArgumentException("Invalid array specification, cannot parse byte values: " + sourceText, e);
            }
            return result;
        }

        @Override
        public void setItem(Object target, int index, String itemSpec) {
            byte value = Byte.parseByte(itemSpec);
            Array.setByte(target, index, value);
        }
    }
    ,
    CHAR((Class)Character.TYPE, (Class)Character.class){

        @Override
        public List<String> parseItems(String sourceText, int initialOffset, int expectedItemCount) {
            List<String> tokens = BasicArraySequenceParsers.TOKENS.parseItems(sourceText, initialOffset, expectedItemCount);
            int totalSize = 0;
            for (String token : tokens) {
                totalSize += token.length();
            }
            ArrayList<String> result = new ArrayList<String>(totalSize);
            for (String token : tokens) {
                char[] tokenChars;
                for (char tokenChar : tokenChars = token.toCharArray()) {
                    result.add(String.valueOf(tokenChar));
                }
            }
            return result;
        }

        @Override
        public void setItem(Object target, int index, String itemSpec) {
            char value = itemSpec.charAt(0);
            Array.setChar(target, index, value);
        }
    }
    ,
    SHORT((Class)Short.TYPE, (Class)Short.class){

        @Override
        public List<String> parseItems(String sourceText, int initialOffset, int expectedItemCount) {
            ArrayList<String> result = new ArrayList<String>(expectedItemCount);
            try {
                Scanner scanner = new Scanner(sourceText.substring(initialOffset));
                while (scanner.hasNext()) {
                    short num = scanner.nextShort();
                    result.add(String.valueOf(num));
                }
            }
            catch (InputMismatchException e) {
                throw new IllegalArgumentException("Invalid array specification, cannot parse short values: " + sourceText, e);
            }
            return result;
        }

        @Override
        public void setItem(Object target, int index, String itemSpec) {
            short value = Short.parseShort(itemSpec);
            Array.setShort(target, index, value);
        }
    }
    ,
    INT((Class)Integer.TYPE, (Class)Integer.class){

        @Override
        public List<String> parseItems(String sourceText, int initialOffset, int expectedItemCount) {
            ArrayList<String> result = new ArrayList<String>(expectedItemCount);
            try {
                Scanner scanner = new Scanner(sourceText.substring(initialOffset));
                while (scanner.hasNext()) {
                    int num = scanner.nextInt();
                    result.add(String.valueOf(num));
                }
            }
            catch (InputMismatchException e) {
                throw new IllegalArgumentException("Invalid array specification, cannot parse integer values: " + sourceText, e);
            }
            return result;
        }

        @Override
        public void setItem(Object target, int index, String itemSpec) {
            int value = Integer.parseInt(itemSpec);
            Array.setInt(target, index, value);
        }
    }
    ,
    LONG((Class)Long.TYPE, (Class)Long.class){

        @Override
        public List<String> parseItems(String sourceText, int initialOffset, int expectedItemCount) {
            ArrayList<String> result = new ArrayList<String>(expectedItemCount);
            try {
                Scanner scanner = new Scanner(sourceText.substring(initialOffset));
                while (scanner.hasNext()) {
                    long num = scanner.nextLong();
                    result.add(String.valueOf(num));
                }
            }
            catch (InputMismatchException e) {
                throw new IllegalArgumentException("Invalid array specification, cannot parse long integer values: " + sourceText, e);
            }
            return result;
        }

        @Override
        public void setItem(Object target, int index, String itemSpec) {
            long value = Long.parseLong(itemSpec);
            Array.setLong(target, index, value);
        }
    }
    ,
    FLOAT((Class)Float.TYPE, (Class)Float.class){

        @Override
        public List<String> parseItems(String sourceText, int initialOffset, int expectedItemCount) {
            ArrayList<String> result = new ArrayList<String>(expectedItemCount);
            try {
                Scanner scanner = new Scanner(sourceText.substring(initialOffset));
                scanner.useLocale(Locale.US);
                while (scanner.hasNext()) {
                    float num = scanner.nextFloat();
                    result.add(String.valueOf(num));
                }
            }
            catch (InputMismatchException e) {
                throw new IllegalArgumentException("Invalid array specification, cannot parse float values: " + sourceText, e);
            }
            return result;
        }

        @Override
        public void setItem(Object target, int index, String itemSpec) {
            float value = Float.parseFloat(itemSpec);
            Array.setFloat(target, index, value);
        }
    }
    ,
    DOUBLE((Class)Double.TYPE, (Class)Double.class){

        @Override
        public List<String> parseItems(String sourceText, int initialOffset, int expectedItemCount) {
            ArrayList<String> result = new ArrayList<String>(expectedItemCount);
            try {
                Scanner scanner = new Scanner(sourceText.substring(initialOffset));
                scanner.useLocale(Locale.US);
                while (scanner.hasNext()) {
                    double num = scanner.nextDouble();
                    result.add(String.valueOf(num));
                }
            }
            catch (InputMismatchException e) {
                throw new IllegalArgumentException("Invalid array specification, cannot parse double values: " + sourceText, e);
            }
            return result;
        }

        @Override
        public void setItem(Object target, int index, String itemSpec) {
            double value = Double.parseDouble(itemSpec);
            Array.setDouble(target, index, value);
        }
    };

    private final Class<?> itemType;
    private final Class<?> boxedType;
    static final Set<String> BOOLEAN_TRUE_VALUES;
    static final Set<String> BOOLEAN_FALSE_VALUES;

    private PrimitiveArrayItemSupport(Class<?> itemType, Class<?> boxedType) {
        this.itemType = itemType;
        this.boxedType = boxedType;
    }

    @Override
    public Class<?> getItemType() {
        return this.itemType;
    }

    public static PrimitiveArrayItemSupport forType(Class<?> type) {
        for (PrimitiveArrayItemSupport filler : PrimitiveArrayItemSupport.values()) {
            if (type != filler.itemType) continue;
            return filler;
        }
        return null;
    }

    public static PrimitiveArrayItemSupport forBoxedType(Class<?> type) {
        for (PrimitiveArrayItemSupport filler : PrimitiveArrayItemSupport.values()) {
            if (type != filler.boxedType) continue;
            return filler;
        }
        return null;
    }

    static {
        BOOLEAN_TRUE_VALUES = new HashSet<String>(Arrays.asList("1", "Y", "y", "T", "t"));
        BOOLEAN_FALSE_VALUES = new HashSet<String>(Arrays.asList("0", "N", "n", "F", "f"));
    }
}

