/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.text;

import cz.auderis.test.matcher.text.CommonCharPattern;
import cz.auderis.test.matcher.text.PrefixMatcher;
import cz.auderis.test.matcher.text.SimpleCharPatternMatcher;
import cz.auderis.test.matcher.text.SuffixMatcher;
import cz.auderis.test.matcher.text.TextPatternMatcher;
import java.util.regex.Pattern;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public final class TextMatchers {
    @Factory
    public static <T> Matcher<CharSequence> matchingPattern(Pattern p) {
        assert (null != p);
        return new TextPatternMatcher(p);
    }

    @Factory
    public static <T> Matcher<CharSequence> matchingPattern(String textPattern) {
        assert (null != textPattern);
        Pattern p = Pattern.compile(textPattern);
        return new TextPatternMatcher(p);
    }

    @Factory
    public static <T extends CharSequence> Matcher<T> withPrefix(String prefix) {
        return new PrefixMatcher(prefix, true);
    }

    @Factory
    public static <T extends CharSequence> Matcher<T> withCaseInsensitivePrefix(String prefix) {
        return new PrefixMatcher(prefix, false);
    }

    @Factory
    public static <T extends CharSequence> Matcher<T> withSuffix(String suffix) {
        return new SuffixMatcher(suffix, true);
    }

    @Factory
    public static <T extends CharSequence> Matcher<T> withCaseInsensitiveSuffix(String suffix) {
        return new SuffixMatcher(suffix, false);
    }

    @Factory
    public static <T> Matcher<CharSequence> validJavaIdentifier() {
        return new SimpleCharPatternMatcher(CommonCharPattern.JAVA_IDENTIFIER);
    }

    @Factory
    public static <T> Matcher<CharSequence> validXmlName() {
        return new SimpleCharPatternMatcher(CommonCharPattern.XML_NAME);
    }

    @Factory
    public static <T> Matcher<CharSequence> validDecimalNumber() {
        return new SimpleCharPatternMatcher(CommonCharPattern.DECIMAL_DIGITS);
    }

    @Factory
    public static <T> Matcher<CharSequence> validHexadecimalNumber() {
        return new SimpleCharPatternMatcher(CommonCharPattern.HEXADECIMAL_DIGITS);
    }

    @Factory
    public static <T> Matcher<CharSequence> validBinaryNumber() {
        return new SimpleCharPatternMatcher(CommonCharPattern.BINARY_DIGITS);
    }

    private TextMatchers() {
        throw new AssertionError();
    }
}

