/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.numeric;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

class InRangeIntegerMatcher
extends TypeSafeMatcher<Number> {
    private static final Set<Class<?>> INTEGER_CLASSES = InRangeIntegerMatcher.supportedIntegerClasses();
    private final Long lowEnd;
    private final Long highEnd;
    private final boolean includeLowEnd;
    private final boolean includeHighEnd;

    InRangeIntegerMatcher(Long low, Long high, boolean includeLow, boolean includeHigh) {
        super(Number.class);
        if (null != low && null != high) {
            int cmp = high.compareTo(low);
            if (cmp < 0) {
                throw new IllegalArgumentException("invalid range definition - high < low");
            }
            if (!(0 != cmp || includeLow && includeHigh)) {
                throw new IllegalArgumentException("invalid range definition - range empty");
            }
        }
        this.lowEnd = low;
        this.highEnd = high;
        this.includeLowEnd = includeLow;
        this.includeHighEnd = includeHigh;
    }

    private boolean isUnsupportedNumberType(Number num) {
        Class<?> numClass = num.getClass();
        return !INTEGER_CLASSES.contains(numClass);
    }

    protected boolean matchesSafely(Number num) {
        if (this.isUnsupportedNumberType(num)) {
            return false;
        }
        long value = num.longValue();
        if (null != this.lowEnd && (value < this.lowEnd || !this.includeLowEnd && value == this.lowEnd)) {
            return false;
        }
        return null == this.highEnd || value <= this.highEnd && (this.includeHighEnd || value != this.highEnd);
    }

    public void describeTo(Description description) {
        String rangeBrace;
        description.appendText("in range ");
        if (null == this.lowEnd) {
            description.appendText("(-inf");
        } else {
            rangeBrace = this.includeLowEnd ? "[" : "(";
            description.appendText(rangeBrace).appendText(this.lowEnd.toString());
        }
        description.appendText("; ");
        if (null == this.highEnd) {
            description.appendText("+inf)");
        } else {
            rangeBrace = this.includeHighEnd ? "]" : ")";
            description.appendText(this.highEnd.toString()).appendText(rangeBrace);
        }
    }

    protected void describeMismatchSafely(Number num, Description out) {
        out.appendText("was ").appendValue((Object)num);
        if (this.isUnsupportedNumberType(num)) {
            out.appendText(" of unsupported type ").appendValue(num.getClass());
            return;
        }
        long value = num.longValue();
        if (null != this.lowEnd) {
            if (value < this.lowEnd) {
                out.appendText(", less than lower range limit");
            } else if (!this.includeLowEnd && value == this.lowEnd) {
                out.appendText(", equal to excluded lower range limit");
            }
        }
        if (null != this.highEnd) {
            if (value > this.highEnd) {
                out.appendText(", greater than upper range limit");
            } else if (!this.includeHighEnd && value == this.highEnd) {
                out.appendText(", equal to excluded upper range limit");
            }
        }
    }

    private static Set<Class<?>> supportedIntegerClasses() {
        HashSet<Class<AtomicLong>> classes = new HashSet<Class<AtomicLong>>(16);
        classes.add(Byte.TYPE);
        classes.add(Byte.class);
        classes.add(Short.TYPE);
        classes.add(Short.class);
        classes.add(Integer.TYPE);
        classes.add(Integer.class);
        classes.add(Long.TYPE);
        classes.add(Long.class);
        classes.add(AtomicInteger.class);
        classes.add(AtomicLong.class);
        return Collections.unmodifiableSet(classes);
    }
}

