/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.text;

import java.util.HashSet;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

class PrefixMatcher<T extends CharSequence>
extends TypeSafeMatcher<T> {
    private static final char[][] BRACKET_CANDIDATES = new char[][]{{'<', '>'}, {'[', ']'}, {'\u27ea', '\u27eb'}};
    private final String prefix;
    private final int prefixLength;
    private final boolean caseSensitive;

    PrefixMatcher(String prefix, boolean caseSensitive) {
        super(CharSequence.class);
        if (null == prefix) {
            throw new NullPointerException();
        }
        this.prefix = prefix;
        this.prefixLength = prefix.length();
        this.caseSensitive = caseSensitive;
    }

    protected boolean matchesSafely(CharSequence testedText) {
        int matchLength = this.commonPrefixLength(testedText);
        return this.prefixLength == matchLength;
    }

    private int commonPrefixLength(CharSequence testedText) {
        int resultMultiplier;
        int len;
        int textLen = testedText.length();
        if (textLen >= this.prefixLength) {
            len = this.prefixLength;
            resultMultiplier = 1;
        } else {
            len = textLen;
            resultMultiplier = -1;
        }
        for (int i = 0; i < len; ++i) {
            char prefixCharLC;
            char testedCharLC;
            char prefixCharUC;
            char prefixChar;
            char testedChar = testedText.charAt(i);
            if (testedChar == (prefixChar = this.prefix.charAt(i))) continue;
            if (this.caseSensitive) {
                return resultMultiplier * i;
            }
            char testedCharUC = Character.toUpperCase(testedChar);
            if (testedCharUC == (prefixCharUC = Character.toUpperCase(prefixChar)) || (testedCharLC = Character.toLowerCase(testedChar)) == (prefixCharLC = Character.toLowerCase(prefixChar))) continue;
            return resultMultiplier * i;
        }
        return resultMultiplier * len;
    }

    public void describeTo(Description desc) {
        desc.appendText("beginning with ");
        if (!this.caseSensitive && this.prefixLength > 0) {
            desc.appendText("(case insensitive) ");
        }
        desc.appendValue((Object)this.prefix);
    }

    protected void describeMismatchSafely(CharSequence testedText, Description desc) {
        desc.appendText("was ");
        int matchLength = this.commonPrefixLength(testedText);
        assert (matchLength < this.prefixLength);
        int textLength = testedText.length();
        if (0 == matchLength) {
            desc.appendValue((Object)testedText);
        } else if (-matchLength == textLength) {
            assert (textLength < this.prefixLength);
            desc.appendValue((Object)testedText);
            desc.appendText(", short by ").appendText(Integer.toString(this.prefixLength - textLength)).appendText(" characters");
        } else if (matchLength > 0) {
            String[] bracket = PrefixMatcher.selectBracket(testedText);
            StringBuilder str = new StringBuilder(textLength + bracket[0].length() + bracket[1].length());
            for (int i = 0; i < textLength; ++i) {
                if (matchLength == i) {
                    str.append(bracket[0]);
                } else if (this.prefixLength == i) {
                    str.append(bracket[1]);
                }
                str.append(testedText.charAt(i));
            }
            if (this.prefixLength == textLength) {
                str.append(bracket[1]);
            }
            desc.appendValue((Object)str.toString());
            desc.appendText(", with mismatch starting at position ").appendText(Integer.toString(matchLength));
        } else {
            String[] bracket = PrefixMatcher.selectBracket(testedText);
            StringBuilder str = new StringBuilder(textLength + bracket[0].length() + bracket[1].length());
            for (int i = 0; i < textLength; ++i) {
                if (-matchLength == i) {
                    str.append(bracket[0]);
                }
                str.append(testedText.charAt(i));
            }
            str.append(bracket[1]);
            desc.appendValue((Object)str.toString());
            desc.appendText(", short by ").appendText(Integer.toString(this.prefixLength - textLength)).appendText(" characters");
            desc.appendText(" and with mismatch starting at position ").appendText(Integer.toString(-matchLength));
        }
    }

    private static String[] selectBracket(CharSequence testedText) {
        HashSet<Character> availableBracketChars = new HashSet<Character>(2 * BRACKET_CANDIDATES.length);
        for (char[] bracketCandidate : BRACKET_CANDIDATES) {
            availableBracketChars.add(Character.valueOf(bracketCandidate[0]));
            availableBracketChars.add(Character.valueOf(bracketCandidate[1]));
        }
        int length = testedText.length();
        for (int i = 0; i < length; ++i) {
            availableBracketChars.remove(Character.valueOf(testedText.charAt(i)));
        }
        String[] result = new String[2];
        for (char[] bracketCandidate : BRACKET_CANDIDATES) {
            char c1 = bracketCandidate[0];
            char c2 = bracketCandidate[1];
            if (!availableBracketChars.contains(Character.valueOf(c1)) || !availableBracketChars.contains(Character.valueOf(c2))) continue;
            result[0] = Character.toString(c1);
            result[1] = Character.toString(c2);
            return result;
        }
        result[0] = " << ";
        result[1] = " >> ";
        return result;
    }
}

