/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.parameter.annotation.impl;

import cz.auderis.test.support.array.ArrayItemFiller;
import cz.auderis.test.support.array.ArraySequenceParser;
import cz.auderis.test.support.array.MultiArraySupport;
import java.lang.reflect.Array;
import java.util.Queue;
import junitparams.converters.ConversionFailedException;

abstract class AbstractMultiArrayConverter {
    private ArraySequenceParser parser;
    private ArrayItemFiller itemFiller;

    protected AbstractMultiArrayConverter() {
    }

    protected AbstractMultiArrayConverter(ArraySequenceParser parser, ArrayItemFiller itemFiller) {
        this.parser = parser;
        this.itemFiller = itemFiller;
    }

    protected void setItemFiller(ArrayItemFiller itemFiller) {
        this.itemFiller = itemFiller;
    }

    protected void setItemParser(ArraySequenceParser parser) {
        this.parser = parser;
    }

    public Object convert(Object paramObj) throws ConversionFailedException {
        if (null == this.parser) {
            throw new IllegalStateException("item parser was not defined");
        }
        if (null == this.itemFiller) {
            throw new IllegalStateException("item filler was not defined");
        }
        String param = paramObj.toString();
        MultiArraySupport.ParserResult parsedData = MultiArraySupport.parseArraySpec(param, this.parser);
        int[] dimensions = parsedData.dimensions;
        Object result = Array.newInstance(this.itemFiller.getItemType(), dimensions);
        this.fillDimension(result, 0, dimensions, parsedData.items);
        return result;
    }

    protected void fillDimension(Object target, int currentDim, int[] dimensions, Queue<String> items) {
        if (currentDim == dimensions.length - 1) {
            assert (target.getClass().isArray());
            int itemCount = dimensions[currentDim];
            for (int i = 0; i < itemCount; ++i) {
                String itemSpec = items.poll();
                this.itemFiller.setItem(target, i, itemSpec);
            }
        } else {
            int subdimensionCount = dimensions[currentDim];
            for (int i = 0; i < subdimensionCount; ++i) {
                Object subdimension = Array.get(target, i);
                assert (null != subdimension);
                assert (subdimension.getClass().isArray());
                this.fillDimension(subdimension, 1 + currentDim, dimensions, items);
            }
        }
    }
}

