/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.parameter.annotation.impl;

import cz.auderis.test.parameter.annotation.XmlText;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import junitparams.converters.ConversionFailedException;
import junitparams.converters.Converter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlTextAnnotationConverter
implements Converter<XmlText, Source> {
    private static final Pattern ID_PATTERN = Pattern.compile("[a-z][a-z0-9_-]*", 2);
    String prefix = "";
    String suffix = "";
    String schemaUri = "";

    public void initialize(String tag, String prefix, String suffix, String schemaUri) {
        if (null != tag && !tag.isEmpty()) {
            Matcher matcher = ID_PATTERN.matcher(tag);
            boolean validId = matcher.matches();
            assert (validId) : "tag value is invalid: " + tag;
            prefix = '<' + tag + '>';
            suffix = "</" + tag + '>';
        }
        if (null != prefix && !prefix.isEmpty()) {
            this.prefix = this.prefix + prefix;
        }
        if (null != suffix && !suffix.isEmpty()) {
            this.suffix = suffix + this.suffix;
        }
        this.schemaUri = null != schemaUri ? schemaUri : "";
    }

    public void initialize(XmlText annotation) {
        assert (null != annotation);
        this.initialize(annotation.tag().trim(), annotation.prefix(), annotation.suffix(), annotation.schemaUri());
    }

    public Source convert(Object param) throws ConversionFailedException {
        try {
            String inputText = this.prefix + param.toString() + this.suffix;
            StringReader inReader = new StringReader(inputText);
            InputSource baseSource = new InputSource(inReader);
            Source filteredSource = this.filterSourceNamespace(baseSource);
            return filteredSource;
        }
        catch (SAXException e) {
            throw new ConversionFailedException(e.getMessage());
        }
    }

    private Source filterSourceNamespace(InputSource src) throws SAXException {
        assert (null != src);
        XMLReader parentReader = XMLReaderFactory.createXMLReader();
        NamespaceFilter filter = new NamespaceFilter(this.schemaUri, true);
        filter.setParent(parentReader);
        SAXSource saxSource = new SAXSource(filter, src);
        return saxSource;
    }

    static class NamespaceFilter
    extends XMLFilterImpl {
        final String usedNamespaceUri;
        final boolean addNamespace;
        boolean addedNamespace;

        public NamespaceFilter(String namespaceUri, boolean addNamespace) {
            this.addNamespace = addNamespace;
            if (addNamespace) {
                assert (null != namespaceUri);
                this.usedNamespaceUri = namespaceUri;
            } else {
                this.usedNamespaceUri = "";
            }
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            if (this.addNamespace) {
                this.startControlledPrefixMapping();
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            super.startElement(this.usedNamespaceUri, localName, qName, attrs);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(this.usedNamespaceUri, localName, qName);
        }

        @Override
        public void startPrefixMapping(String prefix, String url) throws SAXException {
            if (this.addNamespace) {
                this.startControlledPrefixMapping();
            }
        }

        private void startControlledPrefixMapping() throws SAXException {
            if (this.addedNamespace || !this.addNamespace) {
                return;
            }
            super.startPrefixMapping("", this.usedNamespaceUri);
            this.addedNamespace = true;
        }
    }
}

