/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.support.array;

import cz.auderis.test.support.array.SinkAppendable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteSequenceFormatSupport {
    private static final int BYTE_MASK = 255;
    private static final int NIBBLE_SIZE = 4;
    private static final int NIBBLE_MASK = 15;
    private String startDelimiter;
    private String endDelimiter;
    private String separator;
    private String majorSeparator;
    private int majorGroupBytes;
    private boolean uppercaseDigits;

    public static String defaultFormat(byte[] bytes) {
        ByteSequenceFormatSupport formatter = new ByteSequenceFormatSupport();
        return formatter.format(bytes);
    }

    public static String defaultFormat(ByteBuffer bytes) {
        ByteSequenceFormatSupport formatter = new ByteSequenceFormatSupport();
        return formatter.format(bytes);
    }

    public static String format4(byte[] bytes) {
        return ByteSequenceFormatSupport.defaultGroupFormatter(4).format(bytes);
    }

    public static String format4(ByteBuffer bytes) {
        return ByteSequenceFormatSupport.defaultGroupFormatter(4).format(bytes);
    }

    public static String formatGroups(byte[] bytes, int groupSize) {
        return ByteSequenceFormatSupport.defaultGroupFormatter(groupSize).format(bytes);
    }

    public static String formatGroups(ByteBuffer bytes, int groupSize) {
        return ByteSequenceFormatSupport.defaultGroupFormatter(groupSize).format(bytes);
    }

    public static int defaultFormatTo(byte[] bytes, Appendable output) {
        ByteSequenceFormatSupport formatter = new ByteSequenceFormatSupport();
        return formatter.appendSafe(bytes, output);
    }

    public static int defaultFormatTo(ByteBuffer bytes, Appendable output) {
        ByteSequenceFormatSupport formatter = new ByteSequenceFormatSupport();
        return formatter.appendSafe(bytes, output);
    }

    public static int format4To(byte[] bytes, Appendable output) {
        return ByteSequenceFormatSupport.defaultGroupFormatter(4).appendSafe(bytes, output);
    }

    public static int format4To(ByteBuffer bytes, Appendable output) {
        return ByteSequenceFormatSupport.defaultGroupFormatter(4).appendSafe(bytes, output);
    }

    public static int formatGroupsTo(byte[] bytes, Appendable output, int groupSize) {
        return ByteSequenceFormatSupport.defaultGroupFormatter(groupSize).appendSafe(bytes, output);
    }

    public static int formatGroupsTo(ByteBuffer bytes, Appendable output, int groupSize) {
        return ByteSequenceFormatSupport.defaultGroupFormatter(groupSize).appendSafe(bytes, output);
    }

    public ByteSequenceFormatSupport() {
        this("<", ">", " ");
    }

    public ByteSequenceFormatSupport(String startDelimiter, String endDelimiter, String separator) {
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
        this.separator = separator;
        this.uppercaseDigits = true;
        this.majorGroupBytes = Integer.MAX_VALUE;
        this.majorSeparator = null;
    }

    public String format(byte[] bytes) {
        try {
            int expectedSize = this.getExpectedOutputLength(null != bytes ? bytes.length : -1);
            StringBuilder str = new StringBuilder(expectedSize);
            int[] count = new int[]{0};
            this.appendInternal(bytes, (Appendable)str, count);
            return str.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String format(ByteBuffer data) {
        try {
            int expectedSize = this.getExpectedOutputLength(null != data ? data.remaining() : -1);
            StringBuilder str = new StringBuilder(expectedSize);
            int[] count = new int[]{0};
            ByteBuffer dataView = null != data ? data.asReadOnlyBuffer() : null;
            this.appendInternal(dataView, (Appendable)str, count);
            return str.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public int appendSafe(byte[] bytes, Appendable output) {
        int[] count = new int[]{0};
        try {
            Appendable safeOutput = null != output ? output : SinkAppendable.INSTANCE;
            this.appendInternal(bytes, safeOutput, count);
        }
        catch (IOException e) {
            count[0] = -1 - count[0];
        }
        return count[0];
    }

    public int appendSafe(ByteBuffer data, Appendable output) {
        int[] count = new int[]{0};
        try {
            ByteBuffer dataView = null != data ? data.asReadOnlyBuffer() : null;
            Appendable safeOutput = null != output ? output : SinkAppendable.INSTANCE;
            this.appendInternal(dataView, safeOutput, count);
        }
        catch (IOException e) {
            count[0] = -1 - count[0];
        }
        return count[0];
    }

    public int append(byte[] bytes, Appendable output) throws IOException {
        int[] count = new int[]{0};
        this.appendInternal(bytes, null != output ? output : SinkAppendable.INSTANCE, count);
        return count[0];
    }

    public int append(ByteBuffer data, Appendable output) throws IOException {
        int[] count = new int[]{0};
        ByteBuffer dataView = null != data ? data.asReadOnlyBuffer() : null;
        Appendable safeOutput = null != output ? output : SinkAppendable.INSTANCE;
        this.appendInternal(dataView, safeOutput, count);
        return count[0];
    }

    private void appendInternal(byte[] bytes, Appendable output, int[] count) throws IOException {
        ByteBuffer sourceBuffer = null != bytes ? ByteBuffer.wrap(bytes) : null;
        this.appendInternal(sourceBuffer, output, count);
    }

    protected void appendInternal(ByteBuffer source, Appendable output, int[] count) throws IOException {
        assert (null != output);
        assert (null != count);
        if (null == source) {
            String nullText = String.valueOf(null);
            output.append(nullText);
            count[0] = nullText.length();
            return;
        }
        count[0] = ByteSequenceFormatSupport.appendDelimiter(output, this.startDelimiter);
        String sep = null;
        String majorSep = null;
        int sepLength = null != this.separator ? this.separator.length() : 0;
        boolean hasMajorSeparator = null != this.majorSeparator && this.majorGroupBytes > 0;
        int majorSepLength = hasMajorSeparator ? this.majorSeparator.length() : 0;
        int groupRemaining = 0;
        while (source.hasRemaining()) {
            if (hasMajorSeparator && 0 == groupRemaining) {
                if (null != majorSep) {
                    output.append(majorSep);
                    count[0] = count[0] + majorSepLength;
                } else {
                    majorSep = this.majorSeparator;
                }
                groupRemaining = this.majorGroupBytes;
            } else if (null != sep) {
                output.append(sep);
                count[0] = count[0] + sepLength;
            } else {
                sep = this.separator;
            }
            int byteValue = 0xFF & source.get();
            char hiNibble = Character.forDigit(0xF & byteValue >>> 4, 16);
            char loNibble = Character.forDigit(0xF & byteValue, 16);
            if (this.uppercaseDigits) {
                hiNibble = Character.toUpperCase(hiNibble);
                loNibble = Character.toUpperCase(loNibble);
            } else {
                hiNibble = Character.toLowerCase(hiNibble);
                loNibble = Character.toLowerCase(loNibble);
            }
            output.append(hiNibble);
            count[0] = count[0] + 1;
            output.append(loNibble);
            count[0] = count[0] + 1;
            --groupRemaining;
        }
        count[0] = count[0] + ByteSequenceFormatSupport.appendDelimiter(output, this.endDelimiter);
    }

    protected int getExpectedOutputLength(int byteCount) {
        if (byteCount < 0) {
            return String.valueOf(null).length();
        }
        int size = 2 * byteCount;
        if (null != this.startDelimiter) {
            size += this.startDelimiter.length();
        }
        if (null != this.endDelimiter) {
            size += this.endDelimiter.length();
        }
        if (byteCount > 0) {
            int minorSepLength = null != this.separator ? this.separator.length() : 0;
            size += (byteCount - 1) * minorSepLength;
            if (null != this.majorSeparator && this.majorGroupBytes > 0 && this.majorGroupBytes < byteCount) {
                int sepLengthDiff = this.majorSeparator.length() - minorSepLength;
                int groups = (byteCount + this.majorGroupBytes - 1) / this.majorGroupBytes;
                size += (groups - 1) * sepLengthDiff;
            }
        }
        return size;
    }

    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    public void setStartDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public void setEndDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getMajorSeparator() {
        return this.majorSeparator;
    }

    public void setMajorSeparator(String majorSeparator) {
        this.majorSeparator = majorSeparator;
    }

    public int getMajorGroupBytes() {
        return this.majorGroupBytes;
    }

    public void setMajorGroupBytes(int majorGroupBytes) {
        this.majorGroupBytes = majorGroupBytes;
    }

    public boolean isUppercaseDigits() {
        return this.uppercaseDigits;
    }

    public void setUppercaseDigits(boolean uppercaseDigits) {
        this.uppercaseDigits = uppercaseDigits;
    }

    private static int appendDelimiter(Appendable output, String delimiter) throws IOException {
        int chars = 0;
        if (null != delimiter && !delimiter.isEmpty()) {
            output.append(delimiter);
            chars += delimiter.length();
        }
        return chars;
    }

    private static ByteSequenceFormatSupport defaultGroupFormatter(int groupSize) {
        ByteSequenceFormatSupport formatter = new ByteSequenceFormatSupport();
        formatter.setSeparator(":");
        formatter.setMajorSeparator(" ");
        formatter.setMajorGroupBytes(groupSize);
        return formatter;
    }
}

