/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.log;

import cz.auderis.test.logging.LogLevel;
import cz.auderis.test.logging.LogRecord;
import java.util.Date;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class LogRecordMatcher
extends TypeSafeMatcher<LogRecord> {
    private final Matcher<? super Date> timestampMatcher;
    private final Matcher<? super LogLevel> levelMatcher;
    private final Matcher<? super String> nameMatcher;
    private final Matcher<? super String> messageMatcher;

    protected LogRecordMatcher(Matcher<? super Date> timestamp, Matcher<? super LogLevel> level, Matcher<? super String> name, Matcher<? super String> message) {
        super(LogRecord.class);
        this.timestampMatcher = timestamp;
        this.levelMatcher = level;
        this.nameMatcher = name;
        this.messageMatcher = message;
    }

    protected boolean matchesSafely(LogRecord item) {
        if (null != this.timestampMatcher && !this.timestampMatcher.matches((Object)item.getTimestamp())) {
            return false;
        }
        if (null != this.levelMatcher && !this.levelMatcher.matches((Object)item.getLevel())) {
            return false;
        }
        if (null != this.nameMatcher && !this.nameMatcher.matches((Object)item.getLoggerName())) {
            return false;
        }
        return null == this.messageMatcher || this.messageMatcher.matches((Object)item.getMessage());
    }

    public void describeTo(Description description) {
        description.appendText("log record");
        String separator = null;
        if (null != this.nameMatcher) {
            description.appendText(" with name that ");
            this.nameMatcher.describeTo(description);
            separator = " and ";
        }
        if (null != this.messageMatcher) {
            if (null == separator) {
                description.appendText(" with ");
                separator = " and ";
            } else {
                description.appendText(separator);
            }
            description.appendText("message that ");
            this.messageMatcher.describeTo(description);
        }
        if (null != this.levelMatcher) {
            if (null == separator) {
                description.appendText(" with ");
                separator = " and ";
            } else {
                description.appendText(separator);
            }
            description.appendText("level that ");
            this.levelMatcher.describeTo(description);
        }
        if (null != this.timestampMatcher) {
            if (null != separator) {
                description.appendText(separator);
            } else {
                description.appendText(" with ");
            }
            description.appendText("timestamp that ");
            this.timestampMatcher.describeTo(description);
        }
    }

    protected void describeMismatchSafely(LogRecord item, Description description) {
        String separator = null;
        if (null != this.nameMatcher && !this.nameMatcher.matches((Object)item.getLoggerName())) {
            description.appendText("name ");
            this.nameMatcher.describeMismatch((Object)item.getLoggerName(), description);
            separator = " and ";
        }
        if (null != this.messageMatcher && !this.messageMatcher.matches((Object)item.getMessage())) {
            if (null == separator) {
                separator = " and ";
            } else {
                description.appendText(separator);
            }
            description.appendText("message ");
            this.messageMatcher.describeMismatch((Object)item.getMessage(), description);
        }
        if (null != this.levelMatcher && !this.levelMatcher.matches((Object)item.getLevel())) {
            if (null == separator) {
                separator = " and ";
            } else {
                description.appendText(separator);
            }
            description.appendText("level ");
            this.levelMatcher.describeMismatch((Object)item.getLevel(), description);
        }
        if (null != this.timestampMatcher && !this.timestampMatcher.matches((Object)item.getTimestamp())) {
            if (null != separator) {
                description.appendText(separator);
            }
            description.appendText("timestamp ");
            this.timestampMatcher.describeMismatch((Object)item.getTimestamp(), description);
        }
    }

    @Factory
    public static Matcher<? super LogRecord> hasName(Matcher<? super String> nameMatcher) {
        return new LogRecordMatcher(null, null, nameMatcher, null);
    }

    @Factory
    public static Matcher<? super LogRecord> hasName(String name) {
        return new LogRecordMatcher(null, null, (Matcher<? super String>)CoreMatchers.is((Object)name), null);
    }

    @Factory
    public static Matcher<? super LogRecord> hasLevel(Matcher<? super LogLevel> levelMatcher) {
        return new LogRecordMatcher(null, levelMatcher, null, null);
    }

    @Factory
    public static Matcher<? super LogRecord> hasLevel(LogLevel level) {
        return new LogRecordMatcher(null, (Matcher<? super LogLevel>)CoreMatchers.is((Object)((Object)level)), null, null);
    }

    @Factory
    public static Matcher<? super LogRecord> hasMessage(Matcher<? super String> messageMatcher) {
        return new LogRecordMatcher(null, null, null, messageMatcher);
    }

    @Factory
    public static Matcher<? super LogRecord> hasMessage(String message) {
        return new LogRecordMatcher(null, null, null, (Matcher<? super String>)CoreMatchers.is((Object)message));
    }

    @Factory
    public static Matcher<? super LogRecord> hasLevelAndMessage(Matcher<? super LogLevel> levelMatcher, Matcher<? super String> messageMatcher) {
        return new LogRecordMatcher(null, levelMatcher, null, messageMatcher);
    }

    @Factory
    public static Matcher<? super LogRecord> hasLevelAndMessage(LogLevel level, String message) {
        return new LogRecordMatcher(null, (Matcher<? super LogLevel>)CoreMatchers.is((Object)((Object)level)), null, (Matcher<? super String>)CoreMatchers.is((Object)message));
    }
}

