/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.multi;

import cz.auderis.test.matcher.multi.PropertyExtractor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class IntrospectionPropertyExtractor<T>
implements PropertyExtractor<T, Object> {
    final ExtractorImpl extractor;

    public IntrospectionPropertyExtractor(Class<T> objectClass, String propertyName) {
        if (null == objectClass || null == propertyName) {
            throw new NullPointerException();
        }
        this.extractor = IntrospectionPropertyExtractor.findExtractor(objectClass, propertyName);
    }

    @Override
    public Object extract(T obj) {
        return this.extractor.extract(obj);
    }

    private static ExtractorImpl findExtractor(Class<?> cls, String propertyName) {
        ExtractorImpl result = IntrospectionPropertyExtractor.getBeanPropertyExtractor(cls, propertyName);
        if (null != result) {
            return result;
        }
        result = IntrospectionPropertyExtractor.getGetterExtractor(cls, propertyName);
        if (null != result) {
            return result;
        }
        result = IntrospectionPropertyExtractor.getFieldExtractor(cls, propertyName);
        if (null != result) {
            return result;
        }
        throw new IllegalArgumentException("Cannot find property '" + propertyName + "': " + cls.getName());
    }

    private static ExtractorImpl getBeanPropertyExtractor(Class<?> cls, String propertyName) {
        Method readMethod;
        PropertyDescriptor sourceProperty;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (null == propertyDescriptors) {
                return null;
            }
            if (propertyName.isEmpty()) {
                int defaultPropertyIndex = beanInfo.getDefaultPropertyIndex();
                sourceProperty = propertyDescriptors[defaultPropertyIndex];
            } else {
                PropertyDescriptor foundProperty = null;
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    if (!propertyName.equals(propertyDescriptor.getName())) continue;
                    foundProperty = propertyDescriptor;
                    break;
                }
                sourceProperty = foundProperty;
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Cannot examine class " + cls.getName() + ": property '" + propertyName + '\'', e);
        }
        Method method = readMethod = null != sourceProperty ? sourceProperty.getReadMethod() : null;
        if (null == readMethod) {
            return null;
        }
        return new BeanPropertyExtractor(propertyName, readMethod);
    }

    private static ExtractorImpl getGetterExtractor(Class<?> cls, String propertyName) {
        String capitalizedPropertyName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String getterName = "get" + capitalizedPropertyName;
        String altGetterName = "is" + capitalizedPropertyName;
        Method foundGetter = null;
        block0: for (Class<?> examinedClass = cls; null != examinedClass; examinedClass = examinedClass.getSuperclass()) {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = examinedClass.getDeclaredMethods()) {
                String methodName;
                Class<?>[] parameterTypes;
                Class<?> returnType;
                if (declaredMethod.isSynthetic() || Void.TYPE == (returnType = declaredMethod.getReturnType()) || Void.class == returnType || 0 != (parameterTypes = declaredMethod.getParameterTypes()).length || !getterName.equals(methodName = declaredMethod.getName()) && !altGetterName.equals(methodName)) continue;
                foundGetter = declaredMethod;
                break block0;
            }
        }
        if (null == foundGetter) {
            return null;
        }
        return new BeanPropertyExtractor(propertyName, foundGetter);
    }

    private static ExtractorImpl getFieldExtractor(Class<?> cls, String propertyName) {
        Field foundField = null;
        block0: for (Class<?> examinedClass = cls; null != examinedClass; examinedClass = examinedClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = examinedClass.getDeclaredFields()) {
                String fieldName = declaredField.getName();
                if (!propertyName.equals(fieldName)) continue;
                foundField = declaredField;
                break block0;
            }
        }
        if (null == foundField) {
            return null;
        }
        return new FieldExtractor(foundField);
    }

    private static final class FieldExtractor
    implements ExtractorImpl {
        final Field field;

        private FieldExtractor(Field field) {
            this.field = field;
        }

        @Override
        public Object extract(Object instance) {
            boolean origAccessible = this.field.isAccessible();
            try {
                this.field.setAccessible(true);
                Object object = this.field.get(instance);
                return object;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot access field '" + this.field.getName() + '\'', e);
            }
            finally {
                this.field.setAccessible(origAccessible);
            }
        }
    }

    private static final class BeanPropertyExtractor
    implements ExtractorImpl {
        final String name;
        final Method propertyGetter;

        private BeanPropertyExtractor(String name, Method propertyGetter) {
            this.name = name;
            this.propertyGetter = propertyGetter;
        }

        @Override
        public Object extract(Object instance) {
            boolean origAccessible = this.propertyGetter.isAccessible();
            try {
                this.propertyGetter.setAccessible(true);
                Object object = this.propertyGetter.invoke(instance, new Object[0]);
                return object;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot access property '" + this.name + '\'', e);
            }
            finally {
                this.propertyGetter.setAccessible(origAccessible);
            }
        }
    }

    private static interface ExtractorImpl {
        public Object extract(Object var1);
    }
}

