/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.numeric;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

class InBigRangeMatcher
extends TypeSafeMatcher<Number> {
    private final BigDecimal lowEnd;
    private final BigDecimal highEnd;
    private final boolean includeLowEnd;
    private final boolean includeHighEnd;

    InBigRangeMatcher(BigDecimal low, BigDecimal high, boolean includeLow, boolean includeHigh) {
        super(Number.class);
        if (null != low && null != high) {
            int cmp = high.compareTo(low);
            if (cmp < 0) {
                throw new IllegalArgumentException("invalid range definition - high < low");
            }
            if (!(0 != cmp || includeLow && includeHigh)) {
                throw new IllegalArgumentException("invalid range definition - range empty");
            }
        }
        this.lowEnd = low;
        this.highEnd = high;
        this.includeLowEnd = includeLow;
        this.includeHighEnd = includeHigh;
    }

    private BigDecimal toBigValue(Number num) {
        BigDecimal value = num instanceof BigDecimal ? (BigDecimal)num : (num instanceof Double || num instanceof Float ? BigDecimal.valueOf(num.doubleValue()) : (num instanceof BigInteger ? new BigDecimal((BigInteger)num) : BigDecimal.valueOf(num.longValue())));
        return value;
    }

    protected boolean matchesSafely(Number num) {
        int cmp;
        BigDecimal value = this.toBigValue(num);
        if (null != this.lowEnd && ((cmp = value.compareTo(this.lowEnd)) < 0 || !this.includeLowEnd && 0 == cmp)) {
            return false;
        }
        return null == this.highEnd || (cmp = value.compareTo(this.highEnd)) <= 0 && (this.includeHighEnd || 0 != cmp);
    }

    public void describeTo(Description description) {
        String rangeBrace;
        description.appendText("in range ");
        if (null == this.lowEnd) {
            description.appendText("(-inf");
        } else {
            rangeBrace = this.includeLowEnd ? "[" : "(";
            description.appendText(rangeBrace).appendText(this.lowEnd.toString());
        }
        description.appendText("; ");
        if (null == this.highEnd) {
            description.appendText("+inf)");
        } else {
            rangeBrace = this.includeHighEnd ? "]" : ")";
            description.appendText(this.highEnd.toString()).appendText(rangeBrace);
        }
    }

    protected void describeMismatchSafely(Number num, Description out) {
        out.appendText("was ").appendValue((Object)num);
        BigDecimal value = this.toBigValue(num);
        if (null != this.lowEnd) {
            if (value.compareTo(this.lowEnd) < 0) {
                out.appendText(", less than lower range limit");
            } else if (!this.includeLowEnd && 0 == value.compareTo(this.lowEnd)) {
                out.appendText(", equal to excluded lower range limit");
            }
        }
        if (null != this.highEnd) {
            if (value.compareTo(this.highEnd) > 0) {
                out.appendText(", greater than upper range limit");
            } else if (!this.includeHighEnd && 0 == value.compareTo(this.highEnd)) {
                out.appendText(", equal to excluded upper range limit");
            }
        }
    }
}

