/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.logging;

import cz.auderis.test.logging.LogLevel;
import cz.auderis.test.logging.LogLevelConfiguration;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public abstract class AbstractLogLevelConfiguration
implements LogLevelConfiguration {
    private transient String description;

    protected abstract Set<LogLevel> getLevelSet();

    protected void levelSetChanged() {
    }

    @Override
    public Set<LogLevel> getEnabledLevels() {
        return EnumSet.copyOf(this.getLevelSet());
    }

    @Override
    public boolean isLevelEnabled(LogLevel level) {
        if (null == level) {
            throw new NullPointerException();
        }
        return this.getLevelSet().contains((Object)level);
    }

    @Override
    public void setEnabledLevels(Set<LogLevel> levelsToEnable) {
        this.ensureValidLevels(levelsToEnable);
        Set<LogLevel> targetLevels = this.getLevelSet();
        boolean levelsRemoved = targetLevels.retainAll(levelsToEnable);
        boolean levelsAdded = targetLevels.addAll(levelsToEnable);
        if (levelsAdded || levelsRemoved) {
            this.description = null;
            this.levelSetChanged();
        }
    }

    @Override
    public LogLevelConfiguration enableOnly(LogLevel ... levelsToEnable) {
        this.ensureValidLevels(levelsToEnable);
        EnumSet<Object> newLevelSet = 0 == levelsToEnable.length ? EnumSet.noneOf(LogLevel.class) : EnumSet.of(levelsToEnable[0], levelsToEnable);
        this.setEnabledLevels(newLevelSet);
        return this;
    }

    @Override
    public LogLevelConfiguration enableOnly(Collection<LogLevel> levelsToEnable) {
        this.ensureValidLevels(levelsToEnable);
        EnumSet<LogLevel> newLevels = levelsToEnable instanceof Set ? (EnumSet<LogLevel>)levelsToEnable : EnumSet.copyOf(levelsToEnable);
        this.setEnabledLevels(newLevels);
        return this;
    }

    @Override
    public LogLevelConfiguration enableAllLevels() {
        this.setEnabledLevels(EnumSet.allOf(LogLevel.class));
        return this;
    }

    @Override
    public LogLevelConfiguration disableAllLevels() {
        this.setEnabledLevels(EnumSet.noneOf(LogLevel.class));
        return this;
    }

    @Override
    public LogLevelConfiguration enable(LogLevel ... levelsToEnable) {
        this.ensureValidLevels(levelsToEnable);
        if (levelsToEnable.length > 0) {
            EnumSet<LogLevel[]> newlyAddedLevels = EnumSet.of(levelsToEnable[0], levelsToEnable);
            boolean levelsAdded = this.getLevelSet().addAll(newlyAddedLevels);
            if (levelsAdded) {
                this.description = null;
                this.levelSetChanged();
            }
        }
        return this;
    }

    @Override
    public LogLevelConfiguration enable(Collection<LogLevel> levelsToEnable) {
        this.ensureValidLevels(levelsToEnable);
        boolean levelsAdded = this.getLevelSet().addAll(levelsToEnable);
        if (levelsAdded) {
            this.description = null;
            this.levelSetChanged();
        }
        return this;
    }

    @Override
    public LogLevelConfiguration disable(LogLevel ... levelsToDisable) {
        this.ensureValidLevels(levelsToDisable);
        if (levelsToDisable.length > 0) {
            EnumSet<LogLevel[]> newlyRemovedLevels = EnumSet.of(levelsToDisable[0], levelsToDisable);
            boolean levelsRemoved = this.getLevelSet().removeAll(newlyRemovedLevels);
            if (levelsRemoved) {
                this.description = null;
                this.levelSetChanged();
            }
        }
        return this;
    }

    @Override
    public LogLevelConfiguration disable(Collection<LogLevel> levelsToDisable) {
        this.ensureValidLevels(levelsToDisable);
        boolean levelsRemoved = this.getLevelSet().removeAll(levelsToDisable);
        if (levelsRemoved) {
            this.description = null;
            this.levelSetChanged();
        }
        return this;
    }

    @Override
    public LogLevelConfiguration enableLevelsAtOrAbove(LogLevel thresholdLevel) {
        if (null == thresholdLevel) {
            throw new NullPointerException();
        }
        EnumSet<LogLevel> newlyAddedLevels = thresholdLevel.plusHigherLevels();
        boolean levelsAdded = this.getLevelSet().addAll(newlyAddedLevels);
        if (levelsAdded) {
            this.description = null;
            this.levelSetChanged();
        }
        return this;
    }

    @Override
    public LogLevelConfiguration disableLevelsBelow(LogLevel thresholdLevel) {
        if (null == thresholdLevel) {
            throw new NullPointerException();
        }
        EnumSet<LogLevel> removedLevels = thresholdLevel.getLowerLevels();
        boolean levelsRemoved = this.getLevelSet().removeAll(removedLevels);
        if (levelsRemoved) {
            this.description = null;
            this.levelSetChanged();
        }
        return this;
    }

    private void ensureValidLevels(Collection<LogLevel> levels) {
        if (null == levels) {
            throw new NullPointerException("undefined set of logging levels");
        }
        for (LogLevel level : levels) {
            if (null != level) continue;
            throw new IllegalArgumentException("set of logging levels contains null value");
        }
    }

    private void ensureValidLevels(LogLevel[] levels) {
        for (LogLevel level : levels) {
            if (null != level) continue;
            throw new IllegalArgumentException("set of logging levels contains null value");
        }
    }

    public String toString() {
        if (null == this.description) {
            StringBuilder str = new StringBuilder(128);
            str.append("LogLevelCfg{levels=");
            Set<LogLevel> levels = this.getLevelSet();
            char sep = '\u0000';
            for (LogLevel level : LogLevel.values()) {
                if (!levels.contains((Object)level)) continue;
                if ('\u0000' != sep) {
                    str.append(sep);
                } else {
                    sep = ',';
                }
                str.append(level.name());
            }
            if ('\u0000' == sep) {
                str.append("none");
            }
            str.append('}');
            this.description = str.toString();
        }
        return this.description;
    }
}

