/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.logging;

import cz.auderis.test.logging.LogLevel;
import cz.auderis.test.logging.LogRecord;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class LogRecordCollector {
    private static final EnumSet<LogLevel> INITIAL_LEVELS_INTERNAL = LogLevel.DEBUG.plusHigherLevels();
    public static final Set<LogLevel> INITIAL_LOG_LEVELS = Collections.unmodifiableSet(INITIAL_LEVELS_INTERNAL);
    public static final LogRecordCollector RECORD_COLLECTOR = new LogRecordCollector();
    private final List<LogRecord> collectedRecords = new ArrayList<LogRecord>(1024);
    private final EnumSet<LogLevel> enabledLevels = EnumSet.copyOf(INITIAL_LEVELS_INTERNAL);

    LogRecordCollector() {
    }

    public synchronized void reset() {
        this.collectedRecords.clear();
        this.enabledLevels.clear();
        this.enabledLevels.addAll(INITIAL_LEVELS_INTERNAL);
    }

    public synchronized boolean isLevelEnabled(LogLevel level) {
        return this.enabledLevels.contains((Object)level);
    }

    public synchronized Set<LogLevel> getEnabledLevels() {
        return EnumSet.copyOf(this.enabledLevels);
    }

    public synchronized void setEnabledLevels(Set<LogLevel> newLevels) {
        if (null == newLevels) {
            throw new NullPointerException();
        }
        this.enabledLevels.clear();
        this.enabledLevels.addAll(newLevels);
    }

    public synchronized void add(LogRecord record) {
        if (this.enabledLevels.contains((Object)record.getLevel())) {
            this.collectedRecords.add(record);
        }
    }

    public synchronized List<LogRecord> getRecords() {
        return new ArrayList<LogRecord>(this.collectedRecords);
    }

    public synchronized void dump(PrintStream out, LogLevel threshold) {
        EnumSet<LogLevel> dumpLevels = threshold.plusHigherLevels();
        for (LogRecord record : this.collectedRecords) {
            LogLevel level = record.getLevel();
            if (dumpLevels.contains((Object)level)) continue;
        }
    }
}

