/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.array;

import cz.auderis.test.support.array.MultiArraySupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class ArrayDimensionMatcher
extends BaseMatcher<Object> {
    private final List<Matcher<? super Integer>> dimensionMatchers;
    private String fixedDescription;

    public ArrayDimensionMatcher(List<Matcher<? super Integer>> dimensionMatchers) {
        if (null == dimensionMatchers) {
            throw new NullPointerException();
        }
        if (dimensionMatchers.isEmpty()) {
            throw new IllegalArgumentException("no matchers for dimensions provided");
        }
        int dim = 0;
        for (Matcher<? super Integer> matcher : dimensionMatchers) {
            if (null == matcher) {
                throw new IllegalArgumentException("matcher for dimension " + dim + " is undefined");
            }
            ++dim;
        }
        this.dimensionMatchers = new ArrayList<Matcher<? super Integer>>(dimensionMatchers);
    }

    public void setDescription(String description) {
        this.fixedDescription = description;
    }

    public boolean matches(Object item) {
        return this.matchesInternal(item, this.dimensionMatchers);
    }

    private boolean matchesInternal(Object arrayObj, List<Matcher<? super Integer>> matchers) {
        int dimensionValue;
        boolean objNotArray;
        boolean bl = objNotArray = null == arrayObj || !arrayObj.getClass().isArray();
        if (objNotArray || matchers.isEmpty()) {
            return objNotArray == matchers.isEmpty();
        }
        Matcher<? super Integer> dimensionMatcher = matchers.get(0);
        if (!dimensionMatcher.matches((Object)(dimensionValue = ArrayDimensionMatcher.getArrayLength(arrayObj)))) {
            return false;
        }
        List<Matcher<? super Integer>> remainingMatchers = matchers.subList(1, matchers.size());
        Class<?> itemType = arrayObj.getClass().getComponentType();
        if (!Object.class.isAssignableFrom(itemType)) {
            return remainingMatchers.isEmpty();
        }
        for (Object arrayItem : (Object[])arrayObj) {
            if (this.matchesInternal(arrayItem, remainingMatchers)) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        if (null != this.fixedDescription) {
            description.appendText(this.fixedDescription);
        } else {
            description.appendText("array");
            String separator = " where";
            int dimensionIndex = 1;
            for (Matcher<? super Integer> matcher : this.dimensionMatchers) {
                description.appendText(separator);
                description.appendText(" dimension[" + dimensionIndex + "] ");
                matcher.describeTo(description);
                if (++dimensionIndex == this.dimensionMatchers.size()) {
                    separator = " and";
                    continue;
                }
                separator = ", ";
            }
        }
    }

    public void describeMismatch(Object item, Description description) {
        List<Integer> effectiveDimensions = ArrayDimensionMatcher.computeEffectiveDimensions(item);
        if (effectiveDimensions.isEmpty()) {
            description.appendText("object is not an array");
            return;
        }
        StringBuilder effStr = new StringBuilder(effectiveDimensions.size() * 4);
        String separator = null;
        boolean divergenceDetected = false;
        for (Integer dim : effectiveDimensions) {
            if (null == separator) {
                separator = " x ";
            } else {
                effStr.append(separator);
            }
            effStr.append(dim);
            if (dim >= 0) continue;
            divergenceDetected = true;
        }
        if (divergenceDetected) {
            description.appendText("array does not have consistent dimensions");
        } else if (null != this.fixedDescription) {
            description.appendText("was ");
            description.appendText(String.valueOf(effectiveDimensions.size()));
            description.appendText("-dimensional array ");
            description.appendText(effStr.toString());
        } else if (effectiveDimensions.size() != this.dimensionMatchers.size()) {
            description.appendText("array ");
            description.appendText(effStr.toString());
            description.appendText(" had " + effectiveDimensions.size() + " dimensions");
            description.appendText(" instead of " + this.dimensionMatchers.size());
        } else {
            for (int dimIdx = 0; dimIdx < effectiveDimensions.size(); ++dimIdx) {
                Integer dimension = effectiveDimensions.get(dimIdx);
                Matcher<? super Integer> matcher = this.dimensionMatchers.get(dimIdx);
                if (matcher.matches((Object)dimension)) continue;
                description.appendText("was array ");
                description.appendText(effStr.toString());
                description.appendText(" where dimension[" + (1 + dimIdx) + "] ");
                matcher.describeMismatch((Object)dimension, description);
                break;
            }
        }
    }

    private static List<Integer> computeEffectiveDimensions(Object arrayObj) {
        if (null == arrayObj || !arrayObj.getClass().isArray()) {
            return Collections.emptyList();
        }
        int currentDimension = ArrayDimensionMatcher.getArrayLength(arrayObj);
        Class<?> itemType = arrayObj.getClass().getComponentType();
        if (!itemType.isArray()) {
            return Collections.singletonList(currentDimension);
        }
        List subdim = null;
        for (Object item : (Object[])arrayObj) {
            List<Object> itemDimensions = null == item ? Collections.emptyList() : ArrayDimensionMatcher.computeEffectiveDimensions(item);
            if (null == subdim) {
                subdim = itemDimensions;
                continue;
            }
            if (subdim.equals(itemDimensions)) continue;
            return Arrays.asList(currentDimension, -1);
        }
        if (null == subdim) {
            subdim = Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>(1 + subdim.size());
        result.add(currentDimension);
        result.addAll(subdim);
        return result;
    }

    private static int getArrayLength(Object arrayObj) {
        assert (null != arrayObj);
        assert (arrayObj.getClass().isArray());
        Class<?> itemType = arrayObj.getClass().getComponentType();
        if (Object.class.isAssignableFrom(itemType)) {
            return ((Object[])arrayObj).length;
        }
        if (Integer.TYPE == itemType) {
            return ((int[])arrayObj).length;
        }
        if (Boolean.TYPE == itemType) {
            return ((boolean[])arrayObj).length;
        }
        if (Character.TYPE == itemType) {
            return ((char[])arrayObj).length;
        }
        if (Byte.TYPE == itemType) {
            return ((byte[])arrayObj).length;
        }
        if (Long.TYPE == itemType) {
            return ((long[])arrayObj).length;
        }
        if (Short.TYPE == itemType) {
            return ((short[])arrayObj).length;
        }
        if (Double.TYPE == itemType) {
            return ((double[])arrayObj).length;
        }
        if (Float.TYPE == itemType) {
            return ((float[])arrayObj).length;
        }
        throw new AssertionError((Object)("Unsupported array type: " + arrayObj.getClass()));
    }

    @Factory
    public static Matcher<? super Object> arrayWithDimension(int d) {
        return new ArrayDimensionMatcher(Collections.singletonList(CoreMatchers.is((Object)d)));
    }

    @Factory
    public static Matcher<? super Object> arrayWithDimensions(int d1, int d2, int ... ds) {
        ArrayList<Matcher<? super Integer>> dimMatchers = new ArrayList<Matcher<? super Integer>>(ds.length + 2);
        dimMatchers.add(CoreMatchers.is((Object)d1));
        dimMatchers.add(CoreMatchers.is((Object)d2));
        StringBuilder desc = new StringBuilder(16 + ds.length * 8);
        String separator = " x ";
        desc.append(2 + ds.length);
        desc.append("-dimensional array ").append(d1).append(separator).append(d2);
        for (int dx : ds) {
            dimMatchers.add((Matcher<? super Integer>)CoreMatchers.is((Object)dx));
            desc.append(separator).append(dx);
        }
        ArrayDimensionMatcher matcher = new ArrayDimensionMatcher(dimMatchers);
        matcher.setDescription(desc.toString());
        return matcher;
    }

    @Factory
    public static Matcher<? super Object> arrayWithDimensions(String dimensionSpec) {
        int[] dimensions = MultiArraySupport.parseDimensions(dimensionSpec);
        ArrayList<Matcher<? super Integer>> dimMatchers = new ArrayList<Matcher<? super Integer>>(dimensions.length);
        StringBuilder desc = new StringBuilder(dimensions.length * 8);
        desc.append(dimensions.length);
        desc.append("-dimensional array ");
        String separator = null;
        int[] nArray = dimensions;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer expectedDimension = nArray[i];
            dimMatchers.add((Matcher<? super Integer>)CoreMatchers.is((Object)expectedDimension));
            if (null == separator) {
                separator = " x ";
            } else {
                desc.append(separator);
            }
            desc.append(expectedDimension);
        }
        ArrayDimensionMatcher matcher = new ArrayDimensionMatcher(dimMatchers);
        matcher.setDescription(desc.toString());
        return matcher;
    }
}

