/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class BigDecRoundingMatcher
extends TypeSafeMatcher<BigDecimal> {
    private final int roundingScale;
    private final RoundingMode roundingMode;
    private final Matcher<? super BigDecimal> roundedValueMatcher;

    public BigDecRoundingMatcher(int roundingScale, RoundingMode roundingMode, Matcher<? super BigDecimal> roundedValueMatcher) {
        super(BigDecimal.class);
        assert (null != roundingMode);
        assert (null != roundedValueMatcher);
        this.roundingScale = roundingScale;
        this.roundingMode = roundingMode;
        this.roundedValueMatcher = roundedValueMatcher;
    }

    protected boolean matchesSafely(BigDecimal num) {
        BigDecimal roundedNum = num.setScale(this.roundingScale, this.roundingMode);
        return this.roundedValueMatcher.matches((Object)roundedNum);
    }

    public void describeTo(Description description) {
        description.appendText("decimal number that is ");
        this.roundedValueMatcher.describeTo(description);
        description.appendText(" when its scale is " + this.roundingScale);
        if (RoundingMode.UNNECESSARY != this.roundingMode) {
            description.appendText(" with rounding mode " + (Object)((Object)this.roundingMode));
        }
    }

    protected void describeMismatchSafely(BigDecimal num, Description out) {
        BigDecimal roundedNum = num.setScale(this.roundingScale, this.roundingMode);
        this.roundedValueMatcher.describeMismatch((Object)roundedNum, out);
    }
}

