/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.parameter.annotation.impl;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junitparams.converters.ConversionFailedException;

public abstract class AbstractKeyValueConverter {
    protected static final Pattern KEY_VALUE_PATTERN = Pattern.compile("(?:^\\s*|\\G\\s+)(\\w+)\\s*=\\s*(?:((?!')\\S*)|'((?:[^'\\\\]|\\\\.)*+)(?<!\\\\)')");
    protected Class<?> beanClass;
    protected Class<?> propertyDelegateClass;
    private Object propertyDelegate;

    protected AbstractKeyValueConverter() {
    }

    protected AbstractKeyValueConverter(Class<?> beanClass, Class<?> propertyDelegateClass) {
        this.setTypes(beanClass, propertyDelegateClass);
    }

    protected void setTypes(Class<?> beanClass, Class<?> propertyDelegateClass) {
        if (null == beanClass) {
            throw new NullPointerException();
        }
        this.beanClass = beanClass;
        this.propertyDelegateClass = propertyDelegateClass;
        this.initializePropertyDelegate();
    }

    protected void initializePropertyDelegate() {
        if (null == this.propertyDelegateClass || Void.class == this.propertyDelegateClass || Void.TYPE == this.propertyDelegateClass) {
            this.propertyDelegateClass = null;
            this.propertyDelegate = null;
        } else {
            try {
                this.propertyDelegate = this.propertyDelegateClass.newInstance();
            }
            catch (IllegalAccessException e) {
                this.propertyDelegate = null;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot create property delegate instance for " + this.beanClass + ": " + this.propertyDelegateClass, e);
            }
        }
    }

    public Object convert(Object param) throws ConversionFailedException {
        Object result;
        if (null == param || this.beanClass.isAssignableFrom(param.getClass())) {
            return param;
        }
        List<KeyValue> keyValues = AbstractKeyValueConverter.parseKeyValues(param);
        try {
            result = this.beanClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create instance of a bean: " + this.beanClass, e);
        }
        this.applyProperties(result, keyValues);
        return result;
    }

    void applyProperties(Object target, List<KeyValue> keyValues) {
        for (KeyValue keyValue : keyValues) {
            String propertyName = keyValue.key;
            Setter propertySetter = this.resolvePropertySetter(propertyName);
            if (null != propertySetter) {
                Class<?> setterArgumentType = propertySetter.valueParameterType;
                Object setterArgument = AbstractKeyValueConverter.adaptArgumentToType(keyValue.value, setterArgumentType);
                try {
                    propertySetter.method.setAccessible(true);
                    if (propertySetter.applyOnDelegate) {
                        propertySetter.method.invoke(this.propertyDelegate, target, setterArgument);
                        continue;
                    }
                    propertySetter.method.invoke(target, setterArgument);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot set property '" + propertyName + "' on " + this.beanClass + ": " + setterArgument, e);
                }
                finally {
                    propertySetter.restoreAccess();
                    continue;
                }
            }
            Field propertyField = AbstractKeyValueConverter.findField(propertyName, this.beanClass);
            if (null == propertyField) {
                throw new IllegalArgumentException("Setter for property '" + propertyName + "' not found: " + this.beanClass);
            }
            Class<?> fieldType = propertyField.getType();
            Object fieldValue = AbstractKeyValueConverter.adaptArgumentToType(keyValue.value, fieldType);
            boolean origAccess = propertyField.isAccessible();
            try {
                propertyField.setAccessible(true);
                propertyField.set(target, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot inject field '" + propertyName + "' in " + this.beanClass + ": " + fieldValue, e);
            }
            finally {
                propertyField.setAccessible(origAccess);
            }
        }
    }

    static Object adaptArgumentToType(String value, Class<?> targetType) {
        if (String.class == targetType) {
            return value;
        }
        try {
            Method valueOfMethod = targetType.getMethod("valueOf", String.class);
            Class<?> returnType = valueOfMethod.getReturnType();
            if (Modifier.isStatic(valueOfMethod.getModifiers()) && returnType == targetType) {
                Object valueOfResult = valueOfMethod.invoke(null, value);
                return valueOfResult;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(targetType);
        if (null == propertyEditor) {
            throw new IllegalStateException("No property editor defined: " + targetType);
        }
        propertyEditor.setAsText(value);
        Object setterArgument = propertyEditor.getValue();
        return setterArgument;
    }

    Setter resolvePropertySetter(String propertyName) {
        Method directSetter;
        Method delegateSetter;
        Method directGetter;
        String capitalizedPropertyName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String getterName = "get" + capitalizedPropertyName;
        Method delegateGetter = AbstractKeyValueConverter.findMethod(getterName, this.propertyDelegateClass, this.beanClass);
        Class<Object> propertyType = null != delegateGetter ? delegateGetter.getReturnType() : (null != (directGetter = AbstractKeyValueConverter.findMethod(getterName, this.beanClass, new Class[0])) ? directGetter.getReturnType() : Void.class);
        String setterName = "set" + capitalizedPropertyName;
        if (Void.class != propertyType && null != (delegateSetter = AbstractKeyValueConverter.findMethod(setterName, this.propertyDelegateClass, this.beanClass, propertyType))) {
            return new Setter(delegateSetter, true, propertyType);
        }
        Method delegateStringSetter = AbstractKeyValueConverter.findMethod(setterName, this.propertyDelegateClass, this.beanClass, String.class);
        if (null != delegateStringSetter) {
            return new Setter(delegateStringSetter, true, String.class);
        }
        if (Void.class != propertyType && null != (directSetter = AbstractKeyValueConverter.findMethod(setterName, this.beanClass, propertyType))) {
            return new Setter(directSetter, false, propertyType);
        }
        return null;
    }

    static Method findMethod(String methodName, Class<?> startClass, Class<?> ... argumentTypes) {
        for (Class<?> cls = startClass; null != cls; cls = cls.getSuperclass()) {
            try {
                Method method = cls.getDeclaredMethod(methodName, argumentTypes);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    static Field findField(String fieldName, Class<?> startClass) {
        for (Class<?> cls = startClass; null != cls; cls = cls.getSuperclass()) {
            try {
                Field field = cls.getDeclaredField(fieldName);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    static List<KeyValue> parseKeyValues(Object param) {
        String beanSpec = param.toString();
        LinkedList<KeyValue> recordList = new LinkedList<KeyValue>();
        HashMap<String, KeyValue> recordsByKey = new HashMap<String, KeyValue>(16);
        Matcher beanSpecMatcher = KEY_VALUE_PATTERN.matcher(beanSpec);
        while (beanSpecMatcher.find()) {
            KeyValue keyValue;
            String key = beanSpecMatcher.group(1).intern();
            String value = beanSpecMatcher.group(3);
            if (null == value) {
                value = beanSpecMatcher.group(2);
                if ("<null>".equalsIgnoreCase(value)) {
                    value = null;
                }
            } else {
                value = AbstractKeyValueConverter.unescapeValue(value);
            }
            if (null == (keyValue = (KeyValue)recordsByKey.get(key))) {
                keyValue = new KeyValue(key);
                recordList.add(keyValue);
                recordsByKey.put(key, keyValue);
            }
            keyValue.value = value;
        }
        return recordList;
    }

    static String unescapeValue(String value) {
        int index;
        int length = value.length();
        StringBuilder str = new StringBuilder(length);
        int lastIndex = 0;
        while (-1 != (index = value.indexOf(92, lastIndex))) {
            str.append(value, lastIndex, index);
            int escapedCharIndex = Math.min(index + 1, length - 1);
            str.append(value.charAt(escapedCharIndex));
            lastIndex = escapedCharIndex + 1;
        }
        if (lastIndex < length) {
            str.append(value, lastIndex, length);
        }
        return str.toString();
    }

    static final class Setter {
        final Method method;
        final boolean applyOnDelegate;
        final Class<?> valueParameterType;
        final boolean originallyAccessible;

        Setter(Method method, boolean applyOnDelegate, Class<?> valueParameterType) {
            this.method = method;
            this.applyOnDelegate = applyOnDelegate;
            this.valueParameterType = valueParameterType;
            this.originallyAccessible = method.isAccessible();
        }

        void restoreAccess() {
            if (!this.originallyAccessible) {
                this.method.setAccessible(false);
            }
        }
    }

    static final class KeyValue {
        final String key;
        String value;

        KeyValue(String key) {
            this.key = key;
        }
    }
}

