/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.rule;

import cz.auderis.test.rule.InitialContentsProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class ContentProviders {
    private static final InitialContentsProvider EMPTY_PROVIDER = new EmptyProvider();

    public static InitialContentsProvider lines(CharSequence ... lines) {
        return ContentProviders.lines(Arrays.asList(lines));
    }

    public static InitialContentsProvider lines(Iterable<CharSequence> lines) {
        int size = 0;
        for (CharSequence charSequence : lines) {
            size += null != charSequence ? charSequence.length() + 1 : 0;
        }
        if (0 == size) {
            return EMPTY_PROVIDER;
        }
        StringBuilder contents = new StringBuilder(size);
        for (CharSequence line : lines) {
            if (null == line) continue;
            contents.append(line);
            contents.append('\n');
        }
        byte[] byArray = contents.toString().getBytes(StandardCharsets.UTF_8);
        return new ByteArrayProvider(byArray);
    }

    public static InitialContentsProvider bytes(int ... byteData) {
        int length = byteData.length;
        if (0 == length) {
            return EMPTY_PROVIDER;
        }
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)(0xFF & byteData[i]);
        }
        return new ByteArrayProvider(data);
    }

    public static InitialContentsProvider serializedForm(Object object) {
        ByteArrayProvider provider;
        if (null == object) {
            return EMPTY_PROVIDER;
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("Object is not a serializable type: " + object.getClass());
        }
        try (ByteArrayOutputStream objectData = new ByteArrayOutputStream(1024);
             ObjectOutputStream objectStream = new ObjectOutputStream(objectData);){
            objectStream.writeObject(object);
            objectStream.flush();
            provider = new ByteArrayProvider(objectData.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot serialize object of type " + object.getClass(), e);
        }
        return provider;
    }

    private ContentProviders() {
        throw new AssertionError();
    }

    private static final class ByteArrayProvider
    implements InitialContentsProvider {
        private final byte[] data;

        private ByteArrayProvider(byte[] data) {
            this.data = data;
        }

        @Override
        public InputStream getContents() {
            ByteArrayInputStream stream = new ByteArrayInputStream(this.data);
            return stream;
        }
    }

    private static final class EmptyProvider
    extends InputStream
    implements InitialContentsProvider {
        private EmptyProvider() {
        }

        @Override
        public InputStream getContents() {
            return this;
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

