/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.rule;

import cz.auderis.test.rule.InitialContentsProvider;
import cz.auderis.test.rule.WorkFolderInterface;
import cz.auderis.test.rule.WorkSubFolder;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.LinkedList;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class WorkFolder
extends TemporaryFolder
implements WorkFolderInterface {
    private Class<?> resourceSearchBaseClass;
    private Class<?> currentTestClass;
    private FolderBasedClassLoader folderClassLoader;
    private ClassLoader originalContextClassLoader;
    private boolean contextClassLoaderInstalled;

    public static WorkFolder basic() {
        return new WorkFolder();
    }

    public static WorkFolder subfolderOf(File parentFolder) {
        return new WorkFolder(parentFolder);
    }

    public static WorkFolder subfolderOf(String parentFolderPath) {
        File parentFolder = null == parentFolderPath || parentFolderPath.isEmpty() ? null : new File(parentFolderPath);
        return new WorkFolder(parentFolder);
    }

    protected WorkFolder() {
    }

    protected WorkFolder(File parentFolder) {
        super(parentFolder);
    }

    public WorkFolder withResourceSearchBase(Class<?> searchBase) {
        this.resourceSearchBaseClass = searchBase;
        return this;
    }

    public Statement apply(Statement base, Description description) {
        final Class testClass = description.getTestClass();
        final Statement statement = super.apply(base, description);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    WorkFolder.this.currentTestClass = testClass;
                    statement.evaluate();
                }
                finally {
                    WorkFolder.this.currentTestClass = null;
                    if (WorkFolder.this.contextClassLoaderInstalled) {
                        WorkFolder workFolder = WorkFolder.this;
                        synchronized (workFolder) {
                            Thread.currentThread().setContextClassLoader(WorkFolder.this.originalContextClassLoader);
                            WorkFolder.this.contextClassLoaderInstalled = false;
                        }
                    }
                }
            }
        };
    }

    @Override
    public File asFile() {
        return this.getRoot();
    }

    @Override
    public String absolutePath() {
        return this.getRoot().getAbsolutePath();
    }

    @Override
    public String relativePath() {
        return ".";
    }

    @Override
    public WorkFolderInterface getRootFolder() {
        return this;
    }

    public File newFile() throws IOException {
        return super.newFile();
    }

    @Override
    public File newFile(String targetPath, CharSequence initialContents) throws IOException {
        if (null == targetPath) {
            throw new NullPointerException();
        }
        File target = this.prepareTargetFile(targetPath);
        if (null != initialContents) {
            WorkFolder.writeContents(target, initialContents);
        } else {
            target.createNewFile();
        }
        return target;
    }

    @Override
    public File newFile(String targetPath, InputStream initialContents) throws IOException {
        if (null == targetPath) {
            throw new NullPointerException();
        }
        File target = this.prepareTargetFile(targetPath);
        if (null != initialContents) {
            WorkFolder.copyContents(target, initialContents);
        } else {
            target.createNewFile();
        }
        return target;
    }

    @Override
    public File newFile(String targetPath, InitialContentsProvider contentsProvider) throws IOException {
        InputStream stream = null != contentsProvider ? contentsProvider.getContents() : null;
        return this.newFile(targetPath, stream);
    }

    @Override
    public File newResourceCopy(String targetPath, String resourceName) throws IOException {
        if (null == targetPath || null == resourceName) {
            throw new NullPointerException();
        }
        InputStream resourceStream = this.openResource(resourceName);
        return this.newFile(targetPath, resourceStream);
    }

    @Override
    public File newResourceCopy(String resourceName) throws IOException {
        String fileName = WorkFolder.stripPath(resourceName);
        return this.newResourceCopy(fileName, resourceName);
    }

    @Override
    public WorkFolderInterface subfolder(String ... pathComponents) throws IOException {
        if (0 == pathComponents.length) {
            throw new IllegalArgumentException("no path components given");
        }
        int relativePathLength = WorkFolder.computeRelativePathLength(pathComponents);
        StringBuilder relativePathBuilder = new StringBuilder(relativePathLength);
        File dir = this.getRoot();
        WorkFolder.prepareSubdirs(pathComponents, dir, relativePathBuilder);
        WorkSubFolder folder = new WorkSubFolder(this, relativePathBuilder.toString());
        return folder;
    }

    @Override
    public void clean() throws IOException {
        WorkFolder.recursiveDelete(this.getRoot());
    }

    public ClassLoader getClassLoaderForResources() {
        return this.getClassLoaderForResources(null);
    }

    public synchronized ClassLoader getClassLoaderForResources(ClassLoader parentClassLoader) {
        parentClassLoader = this.resolveParentClassLoader(parentClassLoader);
        FolderBasedClassLoader result = null == this.folderClassLoader ? (this.folderClassLoader = new FolderBasedClassLoader(parentClassLoader)) : (this.folderClassLoader.getParent() != parentClassLoader ? new FolderBasedClassLoader(parentClassLoader) : this.folderClassLoader);
        return result;
    }

    public synchronized void installContextClassLoaderForResources(ClassLoader parentClassLoader) {
        ClassLoader resourceClassLoader = this.getClassLoaderForResources(parentClassLoader);
        Thread currentThread = Thread.currentThread();
        if (!this.contextClassLoaderInstalled) {
            this.originalContextClassLoader = currentThread.getContextClassLoader();
        }
        currentThread.setContextClassLoader(resourceClassLoader);
        this.contextClassLoaderInstalled = true;
    }

    private ClassLoader resolveParentClassLoader(ClassLoader providedParent) {
        if (null != providedParent) {
            return providedParent;
        }
        ClassLoader contextClassLoader = this.contextClassLoaderInstalled ? this.originalContextClassLoader : Thread.currentThread().getContextClassLoader();
        if (null != contextClassLoader) {
            return contextClassLoader;
        }
        ClassLoader resourceClassLoader = null != this.resourceSearchBaseClass ? this.resourceSearchBaseClass.getClassLoader() : null;
        if (null != resourceClassLoader) {
            return resourceClassLoader;
        }
        ClassLoader testClassLoader = null != this.currentTestClass ? this.currentTestClass.getClassLoader() : null;
        if (null != testClassLoader) {
            return testClassLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    private File prepareTargetFile(String targetPath) {
        File target = new File(this.getRoot(), targetPath);
        File fileFolder = target.getParentFile();
        if (null != fileFolder && !fileFolder.exists()) {
            fileFolder.mkdirs();
        }
        return target;
    }

    private InputStream openResource(String resourceName) throws IOException {
        Class<?> searchBase = null != this.resourceSearchBaseClass ? this.resourceSearchBaseClass : this.currentTestClass;
        return searchBase.getResourceAsStream(resourceName);
    }

    Class<?> getResourceSearchBaseClass() {
        return null != this.resourceSearchBaseClass ? this.resourceSearchBaseClass : this.currentTestClass;
    }

    static int computeRelativePathLength(String[] pathComponents) {
        int relativePathLength = 0;
        for (String component : pathComponents) {
            if (null == component) {
                throw new IllegalArgumentException("path component is null");
            }
            if (component.isEmpty()) {
                throw new IllegalArgumentException("path component is empty");
            }
            relativePathLength = relativePathLength + component.length() + 1;
        }
        return relativePathLength;
    }

    static void prepareSubdirs(String[] pathComponents, File baseDir, StringBuilder pathBuilder) {
        File dir = baseDir;
        char sep = '\u0000';
        for (String component : pathComponents) {
            if ('\u0000' == sep) {
                sep = '/';
            } else {
                pathBuilder.append(sep);
            }
            pathBuilder.append(component);
            dir = new File(dir, component);
            if (dir.exists()) continue;
            dir.mkdirs();
        }
    }

    static String stripPath(String resourceName) {
        int lastAltSeparator;
        int filenameStart = 0;
        int lastSeparator = resourceName.lastIndexOf(47);
        if (-1 != lastSeparator) {
            filenameStart = 1 + lastSeparator;
        } else if ('/' != File.separatorChar && -1 != (lastAltSeparator = resourceName.lastIndexOf(File.separatorChar))) {
            filenameStart = 1 + lastAltSeparator;
        }
        if (filenameStart >= resourceName.length()) {
            throw new IllegalArgumentException("Cannot find filename part in resource name: " + resourceName);
        }
        return 0 != filenameStart ? resourceName.substring(filenameStart) : resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyContents(File target, InputStream initialContents) throws IOException {
        FileOutputStream targetStream = new FileOutputStream(target, false);
        try {
            int readBytes;
            byte[] buffer = new byte[8192];
            while (-1 != (readBytes = initialContents.read(buffer))) {
                targetStream.write(buffer, 0, readBytes);
            }
        }
        finally {
            WorkFolder.silentClose(targetStream);
            WorkFolder.silentClose(initialContents);
        }
    }

    static void writeContents(File target, CharSequence initialContents) throws IOException {
        FileWriter writer = new FileWriter(target, false);
        try {
            writer.append(initialContents);
        }
        finally {
            WorkFolder.silentClose(writer);
        }
    }

    static void silentClose(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void recursiveDelete(File dir) {
        LinkedList<File> subdirs = new LinkedList<File>();
        LinkedList<File> deletePending = new LinkedList<File>();
        boolean targetClear = WorkFolder.deleteDirectoryFiles(dir, subdirs);
        if (!targetClear) {
            while (!subdirs.isEmpty()) {
                File targetDir = (File)subdirs.pop();
                boolean dirClean = WorkFolder.deleteDirectoryFiles(targetDir, subdirs);
                if (dirClean) {
                    targetDir.delete();
                    continue;
                }
                deletePending.add(targetDir);
            }
            for (File dirToDelete : deletePending) {
                dirToDelete.delete();
            }
        }
    }

    private static boolean deleteDirectoryFiles(File dir, Deque<File> subdirStore) {
        File[] files = dir.listFiles();
        if (null == files || 0 == files.length) {
            return true;
        }
        boolean noDirsFound = true;
        for (File file : files) {
            if (file.isDirectory()) {
                noDirsFound = false;
                subdirStore.addFirst(file);
                continue;
            }
            file.delete();
        }
        return noDirsFound;
    }

    final class FolderBasedClassLoader
    extends ClassLoader {
        FolderBasedClassLoader(ClassLoader parentClassLoader) {
            super(parentClassLoader);
        }

        @Override
        protected URL findResource(String resourcePath) {
            File resourceFile = new File(WorkFolder.this.getRoot(), resourcePath);
            if (!resourceFile.isFile()) {
                return null;
            }
            try {
                return resourceFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        protected Enumeration<URL> findResources(String resourcePath) throws IOException {
            File resourceFile = new File(WorkFolder.this.getRoot(), resourcePath);
            if (!resourceFile.isFile()) {
                return Collections.emptyEnumeration();
            }
            URL resourceURL = resourceFile.toURI().toURL();
            return Collections.enumeration(Collections.singletonList(resourceURL));
        }
    }
}

