/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.rule;

import cz.auderis.test.rule.InitialContentsProvider;
import cz.auderis.test.rule.WorkFolder;
import cz.auderis.test.rule.WorkFolderInterface;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

class WorkSubFolder
implements WorkFolderInterface {
    private final WorkFolder rootFolder;
    private final String relativePath;
    private final File folderFile;

    WorkSubFolder(WorkFolder rootFolder, String relativePath) {
        this.rootFolder = rootFolder;
        this.relativePath = relativePath;
        this.folderFile = new File(rootFolder.asFile(), relativePath);
    }

    @Override
    public File asFile() {
        return this.folderFile;
    }

    @Override
    public String absolutePath() {
        return this.folderFile.getAbsolutePath();
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    public WorkFolderInterface getRootFolder() {
        return this.rootFolder;
    }

    @Override
    public File newFile(String targetPath) throws IOException {
        if (null == targetPath) {
            throw new NullPointerException();
        }
        File f = this.prepareTargetFile(targetPath);
        f.createNewFile();
        return f;
    }

    @Override
    public File newFile(String targetPath, CharSequence initialContents) throws IOException {
        if (null == targetPath) {
            throw new NullPointerException();
        }
        File f = this.prepareTargetFile(targetPath);
        if (null != initialContents) {
            WorkFolder.writeContents(f, initialContents);
        } else {
            f.createNewFile();
        }
        return f;
    }

    @Override
    public File newFile(String targetPath, InputStream initialContents) throws IOException {
        if (null == targetPath) {
            throw new NullPointerException();
        }
        File f = this.prepareTargetFile(targetPath);
        if (null != initialContents) {
            WorkFolder.copyContents(f, initialContents);
        } else {
            f.createNewFile();
        }
        return f;
    }

    @Override
    public File newFile(String targetPath, InitialContentsProvider contentsProvider) throws IOException {
        InputStream stream = null != contentsProvider ? contentsProvider.getContents() : null;
        return this.newFile(targetPath, stream);
    }

    @Override
    public File newResourceCopy(String targetPath, String resourceName) throws IOException {
        if (null == targetPath || null == resourceName) {
            throw new NullPointerException();
        }
        InputStream resourceStream = this.openResource(resourceName);
        return this.newFile(targetPath, resourceStream);
    }

    @Override
    public File newResourceCopy(String resourceName) throws IOException {
        String fileName = WorkFolder.stripPath(resourceName);
        return this.newResourceCopy(fileName, resourceName);
    }

    @Override
    public WorkFolderInterface subfolder(String ... pathComponents) throws IOException {
        if (0 == pathComponents.length) {
            throw new IllegalArgumentException("no path components given");
        }
        int relativePathLength = this.relativePath.length() + WorkFolder.computeRelativePathLength(pathComponents);
        StringBuilder relativePathBuilder = new StringBuilder(relativePathLength);
        relativePathBuilder.append(this.relativePath).append('/');
        WorkFolder.prepareSubdirs(pathComponents, this.folderFile, relativePathBuilder);
        WorkSubFolder folder = new WorkSubFolder(this.rootFolder, relativePathBuilder.toString());
        return folder;
    }

    @Override
    public void clean() throws IOException {
        WorkFolder.recursiveDelete(this.folderFile);
    }

    private File prepareTargetFile(String targetPath) {
        File target = new File(this.folderFile, targetPath);
        File fileFolder = target.getParentFile();
        if (null != fileFolder && !fileFolder.exists()) {
            fileFolder.mkdirs();
        }
        return target;
    }

    private InputStream openResource(String resourceName) throws IOException {
        Class<?> searchBase = this.rootFolder.getResourceSearchBaseClass();
        InputStream streamAsIs = searchBase.getResourceAsStream(resourceName);
        if (null != streamAsIs) {
            return streamAsIs;
        }
        if (-1 == resourceName.indexOf(47) && -1 == resourceName.indexOf(92)) {
            String relativeCandidate = this.relativePath + File.separatorChar + resourceName;
            InputStream relativeStream = searchBase.getResourceAsStream(resourceName);
            if (null != relativeStream) {
                return relativeStream;
            }
        }
        return null;
    }
}

