/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.multi;

import cz.auderis.test.matcher.multi.DummyPropertyEntry;
import cz.auderis.test.matcher.multi.IntrospectionPropertyExtractor;
import cz.auderis.test.matcher.multi.MultiPropertyMatcherContextImpl;
import cz.auderis.test.matcher.multi.PropMatcherEntry;
import cz.auderis.test.matcher.multi.PropertyEntry;
import cz.auderis.test.matcher.multi.PropertyExtractor;
import cz.auderis.test.support.ContextAwareDescriptionProvider;
import cz.auderis.test.support.DescriptionProvider;
import cz.auderis.test.support.MismatchDescriptionProvider;
import cz.auderis.test.support.NaturalDescriptionJoiner;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MultiPropertyMatcher<T>
extends TypeSafeMatcher<T> {
    final Class<T> expectedClass;
    final List<PropMatcherEntry> entries;
    final String objectName;
    Callable<NaturalDescriptionJoiner> joinerProvider;
    Callable<NaturalDescriptionJoiner> mismatchJoinerProvider;
    PropertyEntry lastEntry;
    ContextAwareDescriptionProvider defaultContextReceiver;

    public static <T> MultiPropertyMatcher<T> of(Class<T> targetType, String objectName) {
        return new MultiPropertyMatcher<T>(targetType, objectName);
    }

    public MultiPropertyMatcher(Class<T> matchedTypeClass, String objectName) {
        this(matchedTypeClass, objectName, null, null);
    }

    public MultiPropertyMatcher(Class<T> matchedTypeClass, String objectName, Callable<NaturalDescriptionJoiner> joinerProvider, Callable<NaturalDescriptionJoiner> mismatchJoinerProvider) {
        super(matchedTypeClass);
        this.expectedClass = matchedTypeClass;
        this.entries = new LinkedList<PropMatcherEntry>();
        this.objectName = null != objectName ? objectName : matchedTypeClass.getSimpleName();
        this.joinerProvider = joinerProvider;
        this.mismatchJoinerProvider = mismatchJoinerProvider;
        this.lastEntry = DummyPropertyEntry.INSTANCE;
    }

    public <P> MultiPropertyMatcher<T> addProperty(Object propertyName, Matcher<? super P> propertyMatcher, PropertyExtractor<T, P> propertyExtractor) {
        if (null == propertyMatcher || null == propertyExtractor) {
            this.lastEntry = DummyPropertyEntry.INSTANCE;
        } else {
            Object descriptionPrefix = MultiPropertyMatcher.withSmartRightWhitespace(propertyName);
            PropMatcherEntry entry = new PropMatcherEntry(propertyMatcher, propertyExtractor, descriptionPrefix, null);
            this.entries.add(entry);
            this.lastEntry = entry;
        }
        return this;
    }

    public MultiPropertyMatcher<T> addProperty(String propertyName, Matcher<? super Object> propertyMatcher) {
        IntrospectionPropertyExtractor<T> propertyExtractor = new IntrospectionPropertyExtractor<T>(this.expectedClass, propertyName);
        return this.addProperty(propertyName, propertyMatcher, propertyExtractor);
    }

    public <P> MultiPropertyMatcher<T> addFixedProperty(Object propertyName, P fixedValue, PropertyExtractor<T, P> propertyExtractor) {
        Matcher matcher;
        if (null != fixedValue) {
            String description = fixedValue instanceof CharSequence ? '\"' + fixedValue.toString() + '\"' : '<' + String.valueOf(fixedValue) + '>';
            Matcher baseMatcher = CoreMatchers.is(fixedValue);
            matcher = CoreMatchers.describedAs((String)description, (Matcher)baseMatcher, (Object[])new Object[0]);
        } else {
            matcher = CoreMatchers.nullValue();
        }
        return this.addProperty(propertyName, matcher, propertyExtractor);
    }

    public <P> MultiPropertyMatcher<T> addFixedProperty(String propertyName, P fixedValue) {
        IntrospectionPropertyExtractor<T> propertyExtractor = new IntrospectionPropertyExtractor<T>(this.expectedClass, propertyName);
        return this.addFixedProperty(propertyName, fixedValue, propertyExtractor);
    }

    public MultiPropertyMatcher<T> withPrefix(Object prefix) {
        this.lastEntry.withPrefix(prefix);
        return this;
    }

    public MultiPropertyMatcher<T> withSuffix(Object suffix) {
        this.lastEntry.withSuffix(suffix);
        return this;
    }

    public MultiPropertyMatcher<T> withMatcherDescriber(DescriptionProvider<Matcher<?>> describer) {
        this.lastEntry.withMatcherDescriber(describer);
        return this;
    }

    public MultiPropertyMatcher<T> withMismatchDescriber(MismatchDescriptionProvider<?> describer) {
        this.lastEntry.withMismatchDescriber(describer);
        return this;
    }

    public void setJoinerProvider(Callable<NaturalDescriptionJoiner> joinerProvider) {
        this.joinerProvider = joinerProvider;
    }

    public void setMismatchJoinerProvider(Callable<NaturalDescriptionJoiner> mismatchJoinerProvider) {
        this.mismatchJoinerProvider = mismatchJoinerProvider;
    }

    public void setDefaultContextReceiver(ContextAwareDescriptionProvider defaultContextReceiver) {
        this.defaultContextReceiver = defaultContextReceiver;
    }

    protected boolean matchesSafely(T obj) {
        for (PropMatcherEntry entry : this.entries) {
            if (entry.matches(obj)) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        NaturalDescriptionJoiner joiner;
        description.appendText(this.objectName);
        if (null == this.joinerProvider) {
            joiner = new NaturalDescriptionJoiner(" with ", ", ", " and ", null);
            joiner.withDescriptionContextReceiver(this.defaultContextReceiver);
        } else {
            try {
                joiner = this.joinerProvider.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot describe object " + this.objectName, e);
            }
        }
        joiner.withDescriptionContext(new MultiPropertyMatcherContextImpl(this, null));
        for (PropMatcherEntry entry : this.entries) {
            entry.addToJoiner(joiner);
        }
        joiner.describeTo(description);
    }

    protected void describeMismatchSafely(T item, Description mismatchDescription) {
        NaturalDescriptionJoiner joiner;
        if (null == this.mismatchJoinerProvider) {
            joiner = new NaturalDescriptionJoiner(", ", " and ");
            joiner.withDescriptionContextReceiver(this.defaultContextReceiver);
        } else {
            try {
                joiner = this.mismatchJoinerProvider.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot describe mismatch of object " + this.objectName, e);
            }
        }
        joiner.withDescriptionContext(new MultiPropertyMatcherContextImpl(this, item));
        for (PropMatcherEntry entry : this.entries) {
            entry.addMismatchToJoiner(item, joiner);
        }
        joiner.describeTo(mismatchDescription);
    }

    static Object withSmartRightWhitespace(Object textObj) {
        if (null == textObj || !(textObj instanceof CharSequence)) {
            return textObj;
        }
        CharSequence text = (CharSequence)textObj;
        int length = text.length();
        if (0 == length) {
            return textObj;
        }
        char lastChar = text.charAt(length - 1);
        return Character.isLetterOrDigit(lastChar) ? String.valueOf(text) + ' ' : textObj;
    }
}

