/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.test.matcher.numeric;

import cz.auderis.test.matcher.numeric.BigDecEqualityMatcher;
import cz.auderis.test.matcher.numeric.BigDecPropertyMatcher;
import cz.auderis.test.matcher.numeric.BigDecRoundingMatcher;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public final class BigDecimalMatchers {
    @Factory
    public static <T> Matcher<BigDecimal> hasValue(BigDecimal num) {
        assert (null != num);
        return new BigDecEqualityMatcher(num, false);
    }

    @Factory
    public static <T> Matcher<BigDecimal> isStrictlyEqualTo(BigDecimal num) {
        assert (null != num);
        return new BigDecEqualityMatcher(num, true);
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasScale(Matcher<? super Integer> scaleMatcher) {
        assert (null != scaleMatcher);
        return new BigDecPropertyMatcher(null, scaleMatcher, false, false);
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasScale(int expectedScale) {
        return new BigDecPropertyMatcher(null, (Matcher<? super Integer>)CoreMatchers.is((Object)expectedScale), false, false);
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasNormalizedScale(Matcher<? super Integer> scaleMatcher) {
        assert (null != scaleMatcher);
        return new BigDecPropertyMatcher(null, scaleMatcher, false, true);
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasNormalizedScale(int expectedScale) {
        return new BigDecPropertyMatcher(null, (Matcher<? super Integer>)CoreMatchers.is((Object)expectedScale), false, true);
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasPrecision(Matcher<? super Integer> precisionMatcher) {
        assert (null != precisionMatcher);
        return new BigDecPropertyMatcher(precisionMatcher, null, false, false);
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasNormalizedPrecision(Matcher<? super Integer> precisionMatcher) {
        assert (null != precisionMatcher);
        return new BigDecPropertyMatcher(precisionMatcher, null, true, false);
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasPrecision(int expectedPrecision) {
        return new BigDecPropertyMatcher((Matcher<? super Integer>)CoreMatchers.is((Object)expectedPrecision), null, false, false);
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasNormalizedPrecision(int expectedPrecision) {
        return new BigDecPropertyMatcher((Matcher<? super Integer>)CoreMatchers.is((Object)expectedPrecision), null, true, false);
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasRoundedValue(int scale, RoundingMode roundingMode, Matcher<? super BigDecimal> matcher) {
        return new BigDecRoundingMatcher(scale, roundingMode, matcher);
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasRoundedValue(int scale, RoundingMode roundingMode, BigDecimal expectedValue) {
        return new BigDecRoundingMatcher(scale, roundingMode, BigDecimalMatchers.hasValue(expectedValue));
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasRoundedValue(RoundingMode roundingMode, Matcher<? super BigDecimal> matcher) {
        return new BigDecRoundingMatcher(0, roundingMode, matcher);
    }

    @Factory
    public static <T> Matcher<BigDecimal> hasRoundedValue(RoundingMode roundingMode, BigDecimal expectedValue) {
        return new BigDecRoundingMatcher(0, roundingMode, BigDecimalMatchers.hasValue(expectedValue));
    }

    private BigDecimalMatchers() {
        throw new AssertionError();
    }
}

