/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.change;

import cz.auderis.tools.change.ChangeTracker;
import cz.auderis.tools.collection.AlwaysEmptySet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class BasicChangeTracker
implements ChangeTracker {
    private static final Set<String> PROPERTY_IGNORING_SET = new AlwaysEmptySet<String>();
    private int changeCounter;
    private Set<String> changedProperties;

    public static BasicChangeTracker simple() {
        return new BasicChangeTracker(false);
    }

    public static BasicChangeTracker gatheringPropertyNames() {
        return new BasicChangeTracker(true);
    }

    protected BasicChangeTracker(boolean enablePropertyGathering) {
        if (!enablePropertyGathering) {
            this.changedProperties = PROPERTY_IGNORING_SET;
        }
    }

    @Override
    public void resetChanges() {
        this.changeCounter = 0;
        if (null != this.changedProperties) {
            this.changedProperties.clear();
        }
    }

    @Override
    public boolean isChanged() {
        return this.changeCounter > 0;
    }

    @Override
    public int getChangeCount() {
        return this.changeCounter;
    }

    @Override
    public Set<String> getChangedProperties() {
        if (null == this.changedProperties) {
            return Collections.emptySet();
        }
        return this.changedProperties;
    }

    @Override
    public void markChange() {
        ++this.changeCounter;
    }

    @Override
    public void markChange(String propertyName) {
        this.addChangedProperty(propertyName);
    }

    public int updateInt(int origValue, int newValue) {
        return this.updateInt(origValue, newValue, null);
    }

    public int updateInt(int origValue, int newValue, String propertyName) {
        if (origValue != newValue) {
            this.addChangedProperty(propertyName);
        }
        return newValue;
    }

    public short updateShort(short origValue, short newValue) {
        return this.updateShort(origValue, newValue, null);
    }

    public short updateShort(short origValue, short newValue, String propertyName) {
        if (origValue != newValue) {
            this.addChangedProperty(propertyName);
        }
        return newValue;
    }

    public long updateLong(long origValue, long newValue) {
        return this.updateLong(origValue, newValue, null);
    }

    public long updateLong(long origValue, long newValue, String propertyName) {
        if (origValue != newValue) {
            this.addChangedProperty(propertyName);
        }
        return newValue;
    }

    public byte updateByte(byte origValue, byte newValue) {
        return this.updateByte(origValue, newValue, null);
    }

    public byte updateByte(byte origValue, byte newValue, String propertyName) {
        if (origValue != newValue) {
            this.addChangedProperty(propertyName);
        }
        return newValue;
    }

    public boolean updateBoolean(boolean origValue, boolean newValue) {
        return this.updateBoolean(origValue, newValue, null);
    }

    public boolean updateBoolean(boolean origValue, boolean newValue, String propertyName) {
        if (origValue != newValue) {
            this.addChangedProperty(propertyName);
        }
        return newValue;
    }

    public String updateString(String origValue, String newValue) {
        return this.updateString(origValue, newValue, null);
    }

    public String updateString(String origValue, String newValue, String propertyName) {
        boolean origDefined;
        boolean bl = origDefined = null != origValue;
        if (!origDefined && null != newValue || origDefined && !origValue.equals(newValue)) {
            this.addChangedProperty(propertyName);
        }
        return newValue;
    }

    public <T> T updateObject(T origValue, T newValue) {
        return this.updateObject(origValue, newValue, null);
    }

    public <T> T updateObject(T origValue, T newValue, String propertyName) {
        if (!Objects.equals(origValue, newValue)) {
            this.addChangedProperty(propertyName);
        }
        return newValue;
    }

    private void addChangedProperty(String propertyName) {
        ++this.changeCounter;
        if (null == propertyName) {
            return;
        }
        if (null == this.changedProperties) {
            this.changedProperties = new HashSet<String>();
        }
        this.changedProperties.add(propertyName);
    }
}

