/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CircularQueue<E>
implements Collection<E> {
    protected final int capacity;
    protected final QueueEntry<E>[] entries;
    protected int size;
    protected int tailIndex;
    protected volatile long version;
    private final ReadWriteLock lock;

    public CircularQueue(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("circular queue capacity must be positive");
        }
        this.capacity = maxSize;
        QueueEntry[] newEntries = new QueueEntry[this.capacity];
        this.entries = newEntries;
        this.size = 0;
        this.tailIndex = -1;
        this.version = 0L;
        this.lock = new ReentrantReadWriteLock();
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = 0 == this.size;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            ++this.version;
            this.size = 0;
            this.tailIndex = -1;
            Arrays.fill(this.entries, null);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        this.lock.writeLock().lock();
        try {
            ++this.version;
            this.tailIndex = (1 + this.tailIndex) % this.capacity;
            QueueEntry<E> entry = this.entries[this.tailIndex];
            if (null == entry) {
                QueueEntry<E> newEntry = new QueueEntry<E>(e);
                this.entries[this.tailIndex] = newEntry;
                ++this.size;
            } else {
                entry.data = e;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.lock.writeLock().lock();
        try {
            ++this.version;
            for (E e : c) {
                this.tailIndex = (1 + this.tailIndex) % this.capacity;
                QueueEntry<E> entry = this.entries[this.tailIndex];
                if (null == entry) {
                    QueueEntry<E> newEntry = new QueueEntry<E>(e);
                    this.entries[this.tailIndex] = newEntry;
                    ++this.size;
                    continue;
                }
                entry.data = e;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.lock.readLock().lock();
        try {
            if (0 == this.size) {
                Iterator iterator = Collections.emptyIterator();
                return iterator;
            }
            WrappingIterator wrappingIterator = new WrappingIterator();
            return wrappingIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.lock.readLock().lock();
        try {
            int i;
            if (null == o) {
                for (i = 0; i < this.size; ++i) {
                    Object entryData = this.entries[i].data;
                    if (null != this.entries[i].data) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                for (i = 0; i < this.size; ++i) {
                    if (!o.equals(this.entries[i].data)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        if (null == c) {
            throw new NullPointerException();
        }
        if (c.isEmpty()) {
            return true;
        }
        this.lock.readLock().lock();
        try {
            if (0 == this.size) {
                boolean bl = false;
                return bl;
            }
            block5: for (Object o : c) {
                Object entryData;
                int i;
                if (null == o) {
                    for (i = 0; i < this.size; ++i) {
                        entryData = this.entries[i].data;
                        if (null == entryData) continue block5;
                    }
                } else {
                    for (i = 0; i < this.size; ++i) {
                        entryData = this.entries[i].data;
                        if (o.equals(entryData)) continue block5;
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.lock.readLock().lock();
        try {
            Object[] a = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                int srcIdx = (this.tailIndex + 1 + i) % this.capacity;
                a[i] = this.entries[srcIdx].data;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.lock.readLock().lock();
        try {
            if (null == a) {
                throw new NullPointerException();
            }
            if (a.length < this.size) {
                Class<?> type = a.getClass().getComponentType();
                Object[] newArray = (Object[])Array.newInstance(type, this.size);
                a = newArray;
            }
            if (a.length > this.size) {
                a[this.size] = null;
            }
            for (int i = 0; i < this.size; ++i) {
                int srcIdx = (this.tailIndex + 1 + i) % this.capacity;
                Object item = this.entries[srcIdx].data;
                a[i] = item;
            }
            T[] TArray = a;
            return TArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    final class WrappingIterator
    implements Iterator<E> {
        private final long dataVersion;
        private final int lastIdx;
        private int nextIdx;

        WrappingIterator() {
            this.dataVersion = CircularQueue.this.version;
            this.nextIdx = CircularQueue.this.size < CircularQueue.this.capacity ? 0 : (1 + CircularQueue.this.tailIndex) % CircularQueue.this.capacity;
            this.lastIdx = CircularQueue.this.size - 1 + this.nextIdx;
        }

        @Override
        public boolean hasNext() {
            this.checkConsistency();
            return this.nextIdx <= this.lastIdx;
        }

        @Override
        public E next() {
            this.checkConsistency();
            if (this.nextIdx > this.lastIdx) {
                throw new NoSuchElementException();
            }
            QueueEntry nextEntry = CircularQueue.this.entries[this.nextIdx % CircularQueue.this.capacity];
            ++this.nextIdx;
            return nextEntry.data;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void checkConsistency() {
            if (this.dataVersion != CircularQueue.this.version) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static final class QueueEntry<E> {
        protected E data;

        public QueueEntry(E value) {
            this.data = value;
        }
    }
}

