/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LazyMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<K, V> baseMap = null;

    public Map<K, V> getMap() {
        if (null != this.baseMap && this.baseMap.isEmpty()) {
            return null;
        }
        return this.baseMap;
    }

    @Override
    public void clear() {
        if (null != this.baseMap) {
            this.baseMap.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        return null == this.baseMap || this.baseMap.isEmpty();
    }

    @Override
    public int size() {
        return null != this.baseMap ? this.baseMap.size() : 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return null != this.baseMap && this.baseMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object val) {
        return null != this.baseMap && this.baseMap.containsValue(val);
    }

    @Override
    public V get(Object key) {
        if (null == this.baseMap) {
            return null;
        }
        return this.baseMap.get(key);
    }

    @Override
    public V put(K key, V val) {
        this.createLazyMap();
        return this.baseMap.put(key, val);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> otherMap) {
        if (null == otherMap || otherMap.isEmpty()) {
            return;
        }
        this.createLazyMap();
        this.baseMap.putAll(otherMap);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (null == this.baseMap) {
            return Collections.emptySet();
        }
        return this.baseMap.entrySet();
    }

    @Override
    public Set<K> keySet() {
        if (null == this.baseMap) {
            return Collections.emptySet();
        }
        return this.baseMap.keySet();
    }

    @Override
    public V remove(Object key) {
        if (null == this.baseMap) {
            return null;
        }
        return this.baseMap.remove(key);
    }

    @Override
    public Collection<V> values() {
        if (null == this.baseMap) {
            return Collections.emptySet();
        }
        return this.baseMap.values();
    }

    private void createLazyMap() {
        if (null == this.baseMap) {
            this.baseMap = new HashMap();
        }
    }

    @Override
    public int hashCode() {
        if (null == this.baseMap) {
            return 7;
        }
        return 3 * this.baseMap.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !(obj instanceof LazyMap)) {
            return false;
        }
        LazyMap other = (LazyMap)obj;
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        return null == this.baseMap || this.baseMap.equals(other.baseMap);
    }

    public String toString() {
        if (null == this.baseMap) {
            return "{}";
        }
        return this.baseMap.toString();
    }
}

