/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class Loop<T> {
    static final String ERR_TRANSIENT = "loop item is transient object, use its value instead";
    static final String ERR_NOT_ACTIVE = "loop not active";
    static final String ERR_STOPPED = "loop was stopped";
    static final String ERR_REMOVED = "loop item was already removed";
    private static final Iterable EMPTY_LOOP = new EmptyLoop();

    public abstract T value();

    public abstract int index();

    public abstract boolean isFirst();

    public abstract boolean isLast();

    public abstract boolean isRemoved();

    public abstract void remove();

    public abstract void replace(T var1);

    public abstract void stopIteration();

    public static <E> Iterable<Loop<E>> over(Iterable<? extends E> source) {
        if (null == source) {
            return EMPTY_LOOP;
        }
        if (source instanceof List) {
            List sourceList = (List)source;
            if (sourceList.isEmpty()) {
                return EMPTY_LOOP;
            }
            return new ListLoop(sourceList);
        }
        Iterator<E> sourceIterator = source.iterator();
        if (!sourceIterator.hasNext()) {
            return EMPTY_LOOP;
        }
        return new BasicIterableLoop<E>(sourceIterator);
    }

    public static <E> Iterable<Loop<E>> over(Iterator<? extends E> sourceIterator) {
        if (null == sourceIterator || !sourceIterator.hasNext()) {
            return EMPTY_LOOP;
        }
        return new BasicIterableLoop<E>(sourceIterator);
    }

    public static <E> Iterable<Loop<E>> overArray(E ... sourceArray) {
        if (null == sourceArray || 0 == sourceArray.length) {
            return EMPTY_LOOP;
        }
        return new NormalArrayLoop<E>(sourceArray);
    }

    public static Iterable<Loop<Integer>> overArray(int ... sourceArray) {
        if (null == sourceArray || 0 == sourceArray.length) {
            return EMPTY_LOOP;
        }
        return new IntArrayLoop(sourceArray);
    }

    public static Iterable<Loop<Long>> overArray(long ... sourceArray) {
        if (null == sourceArray || 0 == sourceArray.length) {
            return EMPTY_LOOP;
        }
        return new LongArrayLoop(sourceArray);
    }

    public static Iterable<Loop<Short>> overArray(short ... sourceArray) {
        if (null == sourceArray || 0 == sourceArray.length) {
            return EMPTY_LOOP;
        }
        return new ShortArrayLoop(sourceArray);
    }

    public static Iterable<Loop<Byte>> overArray(byte ... sourceArray) {
        if (null == sourceArray || 0 == sourceArray.length) {
            return EMPTY_LOOP;
        }
        return new ByteArrayLoop(sourceArray);
    }

    public static Iterable<Loop<Character>> overArray(char ... sourceArray) {
        if (null == sourceArray || 0 == sourceArray.length) {
            return EMPTY_LOOP;
        }
        return new CharArrayLoop(sourceArray);
    }

    public static Iterable<Loop<Boolean>> overArray(boolean ... sourceArray) {
        if (null == sourceArray || 0 == sourceArray.length) {
            return EMPTY_LOOP;
        }
        return new BooleanArrayLoop(sourceArray);
    }

    public static Iterable<Loop<Character>> over(CharSequence text) {
        if (null == text || 0 == text.length()) {
            return EMPTY_LOOP;
        }
        return new CharSequenceLoop(text);
    }

    public static Iterable<Loop<Integer>> overRange(int minIncl, int maxExcl) {
        if (minIncl >= maxExcl) {
            return EMPTY_LOOP;
        }
        return new RangeLoop(minIncl, maxExcl);
    }

    public int hashCode() {
        throw new UnsupportedOperationException(ERR_TRANSIENT);
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException(ERR_TRANSIENT);
    }

    static final class RangeLoop
    extends AbstractArrayLoop<Integer> {
        private final transient int start;

        protected RangeLoop(int min, int max) {
            super(max - min);
            this.start = min;
        }

        @Override
        protected Integer getValue() {
            return this.start + this.index;
        }

        @Override
        protected void setValue(Integer newValue) {
            throw new UnsupportedOperationException();
        }
    }

    static final class CharSequenceLoop
    extends AbstractArrayLoop<Character> {
        private final transient CharSequence baseText;

        protected CharSequenceLoop(CharSequence baseText) {
            super(baseText.length());
            this.baseText = baseText;
        }

        @Override
        protected Character getValue() {
            return Character.valueOf(this.baseText.charAt(this.index));
        }

        @Override
        protected void setValue(Character newValue) {
            throw new UnsupportedOperationException();
        }
    }

    static final class BooleanArrayLoop
    extends AbstractArrayLoop<Boolean> {
        private final transient boolean[] baseArray;

        protected BooleanArrayLoop(boolean[] baseArray) {
            super(baseArray.length);
            this.baseArray = baseArray;
        }

        @Override
        protected Boolean getValue() {
            return this.baseArray[this.index];
        }

        @Override
        protected void setValue(Boolean newValue) {
            this.baseArray[this.index] = newValue;
        }
    }

    static final class CharArrayLoop
    extends AbstractArrayLoop<Character> {
        private final transient char[] baseArray;

        protected CharArrayLoop(char[] baseArray) {
            super(baseArray.length);
            this.baseArray = baseArray;
        }

        @Override
        protected Character getValue() {
            return Character.valueOf(this.baseArray[this.index]);
        }

        @Override
        protected void setValue(Character newValue) {
            this.baseArray[this.index] = newValue.charValue();
        }
    }

    static final class ByteArrayLoop
    extends AbstractArrayLoop<Byte> {
        private final transient byte[] baseArray;

        protected ByteArrayLoop(byte[] baseArray) {
            super(baseArray.length);
            this.baseArray = baseArray;
        }

        @Override
        protected Byte getValue() {
            return this.baseArray[this.index];
        }

        @Override
        protected void setValue(Byte newValue) {
            this.baseArray[this.index] = newValue;
        }
    }

    static final class ShortArrayLoop
    extends AbstractArrayLoop<Short> {
        private final transient short[] baseArray;

        protected ShortArrayLoop(short[] baseArray) {
            super(baseArray.length);
            this.baseArray = baseArray;
        }

        @Override
        protected Short getValue() {
            return this.baseArray[this.index];
        }

        @Override
        protected void setValue(Short newValue) {
            this.baseArray[this.index] = newValue;
        }
    }

    static final class LongArrayLoop
    extends AbstractArrayLoop<Long> {
        private final transient long[] baseArray;

        protected LongArrayLoop(long[] baseArray) {
            super(baseArray.length);
            this.baseArray = baseArray;
        }

        @Override
        protected Long getValue() {
            return this.baseArray[this.index];
        }

        @Override
        protected void setValue(Long newValue) {
            this.baseArray[this.index] = newValue;
        }
    }

    static final class IntArrayLoop
    extends AbstractArrayLoop<Integer> {
        private final transient int[] baseArray;

        protected IntArrayLoop(int[] baseArray) {
            super(baseArray.length);
            this.baseArray = baseArray;
        }

        @Override
        protected Integer getValue() {
            return this.baseArray[this.index];
        }

        @Override
        protected void setValue(Integer newValue) {
            this.baseArray[this.index] = newValue;
        }
    }

    static final class NormalArrayLoop<E>
    extends AbstractArrayLoop<E> {
        private final transient E[] baseArray;

        protected NormalArrayLoop(E[] baseArray) {
            super(baseArray.length);
            this.baseArray = baseArray;
        }

        @Override
        public E value() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            return this.baseArray[this.index];
        }

        @Override
        public void replace(E newValue) {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            this.baseArray[this.index] = newValue;
        }

        @Override
        public String toString() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            StringBuilder str = new StringBuilder("[");
            str.append(this.index);
            str.append("] ");
            str.append(this.baseArray[this.index]);
            return str.toString();
        }

        @Override
        protected E getValue() {
            return null;
        }

        @Override
        protected void setValue(E newValue) {
        }
    }

    static abstract class AbstractArrayLoop<E>
    extends Loop<E>
    implements Iterator<Loop<E>>,
    Iterable<Loop<E>> {
        private final transient int length;
        protected transient int index;
        private transient boolean last;

        protected AbstractArrayLoop(int length) {
            this.length = length;
            this.index = -1;
            this.last = false;
        }

        protected abstract E getValue();

        protected abstract void setValue(E var1);

        @Override
        public final Iterator<Loop<E>> iterator() {
            return this;
        }

        @Override
        public final boolean hasNext() {
            return !this.last && this.index < this.length - 1;
        }

        @Override
        public final Loop<E> next() {
            if (this.last) {
                throw new NoSuchElementException(Loop.ERR_STOPPED);
            }
            ++this.index;
            if (this.length == this.index) {
                throw new NoSuchElementException();
            }
            return this;
        }

        @Override
        public E value() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            return this.getValue();
        }

        @Override
        public final int index() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            return this.index;
        }

        @Override
        public final boolean isFirst() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            return 0 == this.index;
        }

        @Override
        public final boolean isLast() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            return 1 + this.index == this.length;
        }

        @Override
        public final boolean isRemoved() {
            return false;
        }

        @Override
        public final void remove() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void replace(E newValue) {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            this.setValue(newValue);
        }

        @Override
        public final void stopIteration() {
            this.last = true;
        }

        public String toString() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            StringBuilder str = new StringBuilder("[");
            str.append(this.index);
            str.append("] ");
            str.append(this.getValue());
            return str.toString();
        }
    }

    static final class EmptyLoop
    extends Loop<Object>
    implements Iterable<Loop<Object>>,
    Iterator<Loop<Object>> {
        protected EmptyLoop() {
        }

        @Override
        public Iterator<Loop<Object>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Loop<Object> next() {
            throw new NoSuchElementException();
        }

        @Override
        public Object value() {
            throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
        }

        @Override
        public int index() {
            throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
        }

        @Override
        public boolean isFirst() {
            throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
        }

        @Override
        public boolean isLast() {
            throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
        }

        @Override
        public boolean isRemoved() {
            throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
        }

        @Override
        public void remove() {
            throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
        }

        @Override
        public void replace(Object newValue) {
            throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
        }

        @Override
        public void stopIteration() {
        }
    }

    static final class ListLoop<E>
    extends BasicIterableLoop<E> {
        private final transient List baseList;

        protected ListLoop(List<E> baseList) {
            super(baseList.iterator());
            this.baseList = baseList;
        }

        @Override
        public void replace(E newValue) {
            int idx = this.index();
            if (-1 == idx) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            if (this.isRemoved()) {
                throw new IllegalStateException(Loop.ERR_REMOVED);
            }
            this.baseList.set(idx, newValue);
            this.setCurrent(newValue);
        }
    }

    static class BasicIterableLoop<E>
    extends Loop<E>
    implements Iterator<Loop<E>>,
    Iterable<Loop<E>> {
        private final transient Iterator<? extends E> baseIterator;
        private transient int index;
        private transient int increment;
        private transient E current;
        private transient boolean last;

        protected BasicIterableLoop(Iterator<? extends E> baseIterator) {
            this.baseIterator = baseIterator;
            this.index = -1;
            this.increment = 1;
            this.current = null;
            this.last = false;
        }

        @Override
        public Iterator<Loop<E>> iterator() {
            return this;
        }

        @Override
        public final boolean hasNext() {
            return !this.last && this.baseIterator.hasNext();
        }

        @Override
        public final Loop<E> next() {
            if (this.last) {
                throw new NoSuchElementException(Loop.ERR_STOPPED);
            }
            this.index += this.increment;
            this.increment = 1;
            this.current = this.baseIterator.next();
            return this;
        }

        @Override
        public final E value() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            return this.current;
        }

        @Override
        public final int index() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            return this.index;
        }

        @Override
        public final boolean isFirst() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            return 0 == this.index;
        }

        @Override
        public final boolean isLast() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            return !this.hasNext();
        }

        @Override
        public final boolean isRemoved() {
            return 0 == this.increment;
        }

        @Override
        public final void remove() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            if (this.isRemoved()) {
                throw new IllegalStateException(Loop.ERR_REMOVED);
            }
            this.baseIterator.remove();
            this.increment = 0;
        }

        @Override
        public void replace(E newValue) {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final void stopIteration() {
            this.last = true;
        }

        public final String toString() {
            if (-1 == this.index) {
                throw new IllegalStateException(Loop.ERR_NOT_ACTIVE);
            }
            StringBuilder str = new StringBuilder("[");
            str.append(this.index);
            str.append("] ");
            str.append(this.current);
            return str.toString();
        }

        protected final void setCurrent(E newCurrent) {
            this.current = newCurrent;
        }
    }
}

