/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection;

import cz.auderis.tools.collection.SimpleMapEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class MapEntries {
    public static <K, V> Set<Map.Entry<K, V>> copyFromMap(Map<? extends K, ? extends V> sourceMap) {
        if (null == sourceMap) {
            throw new NullPointerException();
        }
        Set<Map.Entry<? extends K, ? extends V>> sourceEntries = sourceMap.entrySet();
        return MapEntries.copy(sourceEntries);
    }

    public static <K, V> Set<Map.Entry<K, V>> copy(Iterable<? extends Map.Entry<? extends K, ? extends V>> sourceEntries) {
        if (null == sourceEntries) {
            throw new NullPointerException();
        }
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : sourceEntries) {
            if (null == entry) continue;
            if (null == entry.getKey()) {
                throw new IllegalArgumentException("one of source map entries has null key");
            }
            SimpleMapEntry<? extends K, ? extends V> entryCopy = SimpleMapEntry.copyOf(entry);
            result.add(entryCopy);
        }
        return result;
    }

    public static <K, V> void copyFromMap(Map<? extends K, ? extends V> sourceMap, Collection<? super Map.Entry<K, V>> target) {
        if (null == sourceMap || null == target) {
            throw new NullPointerException();
        }
        MapEntries.copy(sourceMap.entrySet(), target);
    }

    public static <K, V> void copy(Iterable<? extends Map.Entry<? extends K, ? extends V>> source, Collection<? super Map.Entry<K, V>> target) {
        if (null == source || null == target) {
            throw new NullPointerException();
        }
        for (Map.Entry<K, V> entry : source) {
            if (null == entry) continue;
            if (null == entry.getKey()) {
                throw new IllegalArgumentException("one of source map entries has null key");
            }
            SimpleMapEntry<? extends K, ? extends V> entryCopy = SimpleMapEntry.copyOf(entry);
            target.add(entryCopy);
        }
    }

    private MapEntries() {
        throw new AssertionError();
    }
}

