/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection;

import cz.auderis.tools.collection.CascadingMap;
import cz.auderis.tools.collection.MapEntries;
import cz.auderis.tools.collection.iterator.Iterators;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MultiLevelMap<K, V>
implements CascadingMap<K, V> {
    protected static final String ERR_ITEMS_NOT_ENTRIES = "all items must be map entries";
    protected final Map<K, V> currentLevel;
    protected final transient MultiLevelEntrySet entrySetView;
    protected final transient MultiLevelKeySet keySetView;
    protected Map<K, V> parent;

    public static <K1, V1> MultiLevelMap<K1, V1> create() {
        return new MultiLevelMap(null, null);
    }

    public static <K1, V1> MultiLevelMap<K1, V1> createWithParent(Map<? extends K1, ? extends V1> parentMap) {
        return new MultiLevelMap<K1, V1>(null, parentMap);
    }

    public static <K1, V1> MultiLevelMap<K1, V1> createWithContentAndParent(Map<? extends K1, ? extends V1> content, Map<? extends K1, ? extends V1> parentMap) {
        return new MultiLevelMap<K1, V1>(content, parentMap);
    }

    protected MultiLevelMap(Map<? extends K, ? extends V> current, Map<? extends K, ? extends V> parent) {
        this.currentLevel = null == current ? new HashMap() : new HashMap<K, V>(current);
        if (null != parent) {
            Map<? extends K, ? extends V> parentMap = parent;
            this.parent = parentMap;
        }
        this.entrySetView = new MultiLevelEntrySet();
        this.keySetView = new MultiLevelKeySet();
    }

    @Override
    public Map<K, V> getParentMap() {
        return this.parent;
    }

    @Override
    public void setParentMap(Map<? extends K, ? extends V> prnt) {
        Map<? extends K, ? extends V> parentMap = prnt;
        this.parent = parentMap;
    }

    @Override
    public boolean hasParentMap() {
        return null != this.parent;
    }

    @Override
    public void clearCurrentMap() {
        this.currentLevel.clear();
    }

    @Override
    public void clearParentMap() {
        if (null != this.parent) {
            this.parent.clear();
        }
    }

    @Override
    public void clear() {
        this.clearCurrentMap();
        try {
            this.clearParentMap();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (null == key) {
            throw new NullPointerException();
        }
        if (this.currentLevel.containsKey(key)) {
            return true;
        }
        return null != this.parent && this.parent.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.currentLevel.containsValue(value)) {
            return true;
        }
        return null != this.parent && this.parent.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySetView;
    }

    @Override
    public V get(Object key) {
        if (null == key) {
            throw new NullPointerException();
        }
        if (this.currentLevel.containsKey(key)) {
            return this.currentLevel.get(key);
        }
        if (null != this.parent && this.parent.containsKey(key)) {
            return this.parent.get(key);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        if (!this.currentLevel.isEmpty()) {
            return false;
        }
        if (null == this.parent) {
            return true;
        }
        return this.parent.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        if (null == key) {
            throw new NullPointerException();
        }
        V oldValue = this.get(key);
        this.currentLevel.put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> otherMap) {
        if (null == otherMap) {
            throw new NullPointerException();
        }
        Set<Map.Entry<K, V>> entrySet = otherMap.entrySet();
        for (Map.Entry<K, V> entry : entrySet) {
            K key = entry.getKey();
            if (null != key) continue;
            throw new IllegalArgumentException("argument map contains null keys");
        }
        for (Map.Entry<K, V> entry : entrySet) {
            this.currentLevel.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V removeFromCurrentMap(Object key) {
        if (null == key) {
            throw new NullPointerException();
        }
        return this.currentLevel.remove(key);
    }

    @Override
    public V remove(Object key) {
        if (null == key) {
            throw new NullPointerException();
        }
        V oldValue = null;
        if (null != this.parent && this.parent.containsKey(key)) {
            oldValue = this.parent.remove(key);
        }
        if (this.currentLevel.containsKey(key)) {
            oldValue = this.currentLevel.remove(key);
        }
        return oldValue;
    }

    @Override
    public int size() {
        int size = this.currentLevel.size();
        if (null != this.parent) {
            Set<Map.Entry<K, V>> entrySet = this.parent.entrySet();
            for (Map.Entry<K, V> entry : entrySet) {
                K key = entry.getKey();
                if (null == key || this.currentLevel.containsKey(key)) continue;
                ++size;
            }
            return size;
        }
        int parentSize = null == this.parent ? 0 : this.parent.size();
        return parentSize + this.currentLevel.size();
    }

    @Override
    public Set<K> keySet() {
        return this.keySetView;
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    private static boolean safeEquals(Object o1, Object o2) {
        if (null == o1 != (null == o2)) {
            return false;
        }
        if (null == o1) {
            return true;
        }
        return o1.equals(o2);
    }

    protected class KeyIterator
    implements Iterator<K> {
        private final EntryIterator baseIterator;

        protected KeyIterator() {
            this.baseIterator = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.baseIterator.hasNext();
        }

        @Override
        public K next() {
            return this.baseIterator.next().getKey();
        }

        @Override
        public void remove() {
            this.baseIterator.remove();
        }
    }

    protected class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> currentIterator;
        private final Iterator<Map.Entry<K, V>> parentIterator;
        private boolean iteratingCurrentLevel;

        protected EntryIterator() {
            this.currentIterator = MultiLevelMap.this.currentLevel.entrySet().iterator();
            if (null != MultiLevelMap.this.parent) {
                HashMap parentCopy = new HashMap(MultiLevelMap.this.parent);
                parentCopy.keySet().removeAll(MultiLevelMap.this.currentLevel.keySet());
                this.parentIterator = parentCopy.entrySet().iterator();
            } else {
                this.parentIterator = Iterators.emptyIterator();
            }
            this.iteratingCurrentLevel = true;
        }

        @Override
        public boolean hasNext() {
            if (this.iteratingCurrentLevel) {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.iteratingCurrentLevel = false;
            }
            return this.parentIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.iteratingCurrentLevel) {
                return this.currentIterator.next();
            }
            return this.parentIterator.next();
        }

        @Override
        public void remove() {
            if (this.iteratingCurrentLevel) {
                this.currentIterator.remove();
            } else if (null != this.parentIterator) {
                this.parentIterator.remove();
            }
        }
    }

    protected class MultiLevelKeySet
    implements Set<K> {
        protected MultiLevelKeySet() {
        }

        @Override
        public void clear() {
            MultiLevelMap.this.entrySetView.clear();
        }

        @Override
        public boolean contains(Object key) {
            return MultiLevelMap.this.containsKey(key);
        }

        @Override
        public boolean containsAll(Collection<?> keys) {
            if (null == keys) {
                throw new NullPointerException();
            }
            for (Object k : keys) {
                if (null == k) {
                    return false;
                }
                if (MultiLevelMap.this.containsKey(k)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return MultiLevelMap.this.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object key) {
            if (null == key) {
                throw new NullPointerException();
            }
            if (!MultiLevelMap.this.containsKey(key)) {
                return false;
            }
            MultiLevelMap.this.remove(key);
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> keys) {
            if (null == keys) {
                throw new NullPointerException();
            }
            boolean changed = false;
            for (Object k : keys) {
                if (null == k || !MultiLevelMap.this.containsKey(k)) continue;
                MultiLevelMap.this.remove(k);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> keys) {
            if (null == keys) {
                throw new NullPointerException();
            }
            HashSet retainedKeys = keys instanceof Set ? (HashSet)keys : new HashSet(keys);
            boolean changed = false;
            Iterator currentLevelIterator = MultiLevelMap.this.currentLevel.keySet().iterator();
            while (currentLevelIterator.hasNext()) {
                Object currentKey = currentLevelIterator.next();
                if (retainedKeys.contains(currentKey)) continue;
                currentLevelIterator.remove();
                changed = true;
            }
            if (null != MultiLevelMap.this.parent) {
                Iterator parentIterator = MultiLevelMap.this.parent.keySet().iterator();
                try {
                    while (parentIterator.hasNext()) {
                        Object parentKey = parentIterator.next();
                        if (retainedKeys.contains(parentKey)) continue;
                        parentIterator.remove();
                        changed = true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return changed;
        }

        @Override
        public int size() {
            return MultiLevelMap.this.size();
        }

        @Override
        public Object[] toArray() {
            if (null == MultiLevelMap.this.parent) {
                return MultiLevelMap.this.currentLevel.keySet().toArray();
            }
            HashSet keyUnion = new HashSet(MultiLevelMap.this.currentLevel.keySet());
            keyUnion.addAll(MultiLevelMap.this.parent.keySet());
            return keyUnion.toArray();
        }

        @Override
        public <T> T[] toArray(T[] baseArray) {
            if (null == MultiLevelMap.this.parent) {
                return MultiLevelMap.this.currentLevel.keySet().toArray(baseArray);
            }
            HashSet keyUnion = new HashSet(MultiLevelMap.this.currentLevel.keySet());
            keyUnion.addAll(MultiLevelMap.this.parent.keySet());
            return keyUnion.toArray(baseArray);
        }

        @Override
        public boolean add(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }
    }

    protected class MultiLevelEntrySet
    implements Set<Map.Entry<K, V>> {
        protected MultiLevelEntrySet() {
        }

        @Override
        public void clear() {
            MultiLevelMap.this.clear();
        }

        @Override
        public boolean contains(Object entryObj) {
            if (null == entryObj) {
                throw new NullPointerException();
            }
            if (!(entryObj instanceof Map.Entry)) {
                throw new IllegalArgumentException("argument is not a map entry");
            }
            Map.Entry entry = (Map.Entry)entryObj;
            Object key = entry.getKey();
            if (null == key || !MultiLevelMap.this.containsKey(key)) {
                return false;
            }
            Object mapValue = MultiLevelMap.this.get(key);
            return MultiLevelMap.safeEquals(entry.getValue(), mapValue);
        }

        @Override
        public boolean containsAll(Collection<?> entryObjs) {
            if (null == entryObjs) {
                throw new NullPointerException();
            }
            for (Object entryObj : entryObjs) {
                if (null == entryObj || !(entryObj instanceof Map.Entry)) {
                    throw new IllegalArgumentException(MultiLevelMap.ERR_ITEMS_NOT_ENTRIES);
                }
                Map.Entry entry = (Map.Entry)entryObj;
                Object key = entry.getKey();
                if (null == key) {
                    return false;
                }
                if (!MultiLevelMap.this.containsKey(key)) {
                    return false;
                }
                Object actualValue = MultiLevelMap.this.get(key);
                if (MultiLevelMap.safeEquals(entry.getValue(), actualValue)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return MultiLevelMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object entryObj) {
            Object actualValue;
            if (null == entryObj) {
                throw new NullPointerException();
            }
            if (!(entryObj instanceof Map.Entry)) {
                throw new IllegalArgumentException("argument is not a map entry");
            }
            Map.Entry entry = (Map.Entry)entryObj;
            Object key = entry.getKey();
            Object value = entry.getValue();
            boolean removed = false;
            if (MultiLevelMap.this.currentLevel.containsKey(key) && MultiLevelMap.safeEquals(value, actualValue = MultiLevelMap.this.currentLevel.get(key))) {
                MultiLevelMap.this.currentLevel.remove(key);
                removed = true;
            }
            if (null != MultiLevelMap.this.parent) {
                try {
                    boolean removedFromParent = MultiLevelMap.this.parent.entrySet().remove(entry);
                    removed = removed || removedFromParent;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return removed;
        }

        @Override
        public boolean removeAll(Collection<?> entryObjs) {
            if (null == entryObjs) {
                throw new NullPointerException();
            }
            for (Object entryObj : entryObjs) {
                if (null != entryObj && entryObj instanceof Map.Entry) continue;
                throw new IllegalArgumentException(MultiLevelMap.ERR_ITEMS_NOT_ENTRIES);
            }
            boolean removed = MultiLevelMap.this.currentLevel.entrySet().removeAll(entryObjs);
            if (null != MultiLevelMap.this.parent) {
                try {
                    boolean removedFromParent = MultiLevelMap.this.parent.entrySet().removeAll(entryObjs);
                    removed = removed || removedFromParent;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return removed;
        }

        @Override
        public boolean retainAll(Collection<?> entryObjs) {
            if (null == entryObjs) {
                throw new NullPointerException();
            }
            for (Object entryObj : entryObjs) {
                if (null != entryObj && entryObj instanceof Map.Entry) continue;
                throw new IllegalArgumentException(MultiLevelMap.ERR_ITEMS_NOT_ENTRIES);
            }
            boolean changed = MultiLevelMap.this.currentLevel.entrySet().retainAll(entryObjs);
            if (null != MultiLevelMap.this.parent) {
                try {
                    boolean parentChanged = MultiLevelMap.this.parent.entrySet().retainAll(entryObjs);
                    changed = changed || parentChanged;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return changed;
        }

        @Override
        public int size() {
            return MultiLevelMap.this.size();
        }

        private Set<Map.Entry<K, V>> getSetSnapshot() {
            Set snapshot = MapEntries.copyFromMap(MultiLevelMap.this.currentLevel);
            if (null != MultiLevelMap.this.parent) {
                Set parentEntries = MultiLevelMap.this.parent.entrySet();
                for (Map.Entry parentEntry : parentEntries) {
                    Object key = parentEntry.getKey();
                    if (null == key || MultiLevelMap.this.currentLevel.containsKey(key)) continue;
                    snapshot.add(parentEntry);
                }
            }
            return snapshot;
        }

        @Override
        public Object[] toArray() {
            return this.getSetSnapshot().toArray();
        }

        @Override
        public <T> T[] toArray(T[] arr) {
            return this.getSetSnapshot().toArray(arr);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> arg0) {
            throw new UnsupportedOperationException();
        }
    }
}

