/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection;

import cz.auderis.tools.time.timeout.Timeout;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SimpleCache<K, V> {
    private final Map<K, CacheEntry<V>> cache = new HashMap<K, CacheEntry<V>>();

    protected SimpleCache() {
    }

    public static <K, V> SimpleCache<K, V> newInstance() {
        return new SimpleCache<K, V>();
    }

    public void put(K key, V value) {
        if (null == key) {
            throw new NullPointerException();
        }
        CacheEntry<V> entry = this.cache.get(key);
        if (null == entry) {
            entry = new CacheEntry<V>(value);
            this.cache.put(key, entry);
        } else {
            entry.setValue(value);
            Timeout t = entry.getTimeout();
            if (null != t) {
                t.restart();
            }
        }
    }

    public void putWithTimeout(K key, V value, Timeout t) {
        if (null == key) {
            throw new NullPointerException();
        }
        CacheEntry<V> entry = this.cache.get(key);
        if (null == entry) {
            entry = new CacheEntry<V>(value);
            entry.setTimeout(t);
            this.cache.put(key, entry);
        } else {
            entry.setValue(value);
            entry.setTimeout(t);
        }
        if (null != t) {
            t.restart();
        }
    }

    public V get(K key) {
        if (null == key) {
            throw new NullPointerException();
        }
        CacheEntry<V> entry = this.cache.get(key);
        if (null == entry) {
            return null;
        }
        if (!entry.isAvailable()) {
            this.cache.remove(key);
            return null;
        }
        return entry.getValue();
    }

    public boolean hasKey(K key) {
        if (null == key) {
            throw new NullPointerException();
        }
        return this.cache.containsKey(key);
    }

    public void remove(K key) {
        if (null == key) {
            throw new NullPointerException();
        }
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean isAvailable(K key) {
        if (null == key) {
            throw new NullPointerException();
        }
        CacheEntry<V> entry = this.cache.get(key);
        if (null == entry) {
            return false;
        }
        return entry.isAvailable();
    }

    public boolean isExpired(K key) {
        if (null == key) {
            throw new NullPointerException();
        }
        CacheEntry<V> entry = this.cache.get(key);
        if (null == entry) {
            return false;
        }
        return entry.isTimeoutExpired();
    }

    public void refresh(K key) {
        if (null == key) {
            throw new NullPointerException();
        }
        CacheEntry<V> entry = this.cache.get(key);
        if (null != entry) {
            entry.refresh();
        }
    }

    static final class CacheEntry<W> {
        private boolean nullStored;
        private SoftReference<W> valueRef;
        private Timeout expiration = null;

        public CacheEntry(W value) {
            if (null == value) {
                this.nullStored = true;
            } else {
                this.valueRef = new SoftReference<W>(value);
            }
        }

        public boolean isAvailable() {
            if (null != this.expiration && this.expiration.isExpired()) {
                return false;
            }
            return this.nullStored || null != this.valueRef.get();
        }

        public boolean isTimeoutExpired() {
            return null != this.expiration && this.expiration.isExpired();
        }

        public W getValue() {
            if (null != this.expiration && this.expiration.isExpired()) {
                return null;
            }
            if (this.nullStored) {
                return null;
            }
            return this.valueRef.get();
        }

        public void setValue(W newValue) {
            if (null == newValue) {
                this.nullStored = true;
                this.valueRef = null;
            } else {
                this.valueRef = new SoftReference<W>(newValue);
                this.nullStored = false;
            }
        }

        public Timeout getTimeout() {
            return this.expiration;
        }

        public void setTimeout(Timeout t) {
            this.expiration = t;
        }

        public void refresh() {
            if (null != this.expiration) {
                this.expiration.restart();
            }
        }
    }
}

