/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;

public final class SimpleMapEntry<K, V>
implements Map.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private K key;
    private V value;
    private transient int keyHashCode;

    public SimpleMapEntry(K key, V value) {
        if (null == key) {
            throw new NullPointerException();
        }
        this.key = key;
        this.keyHashCode = key.hashCode();
        this.value = value;
    }

    public static <K, V> SimpleMapEntry<K, V> copyOf(Map.Entry<? extends K, ? extends V> baseEntry) {
        if (null == baseEntry) {
            throw new NullPointerException();
        }
        K key = baseEntry.getKey();
        if (null == key) {
            throw new IllegalArgumentException("copied map entry key is null");
        }
        V value = baseEntry.getValue();
        return new SimpleMapEntry<K, V>(key, value);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V newValue) {
        V oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @Override
    public int hashCode() {
        return this.keyHashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !(obj instanceof Map.Entry)) {
            return false;
        }
        Map.Entry other = (Map.Entry)obj;
        if (!this.key.equals(other.getKey())) {
            return false;
        }
        return SimpleMapEntry.safeEquals(this.value, other.getValue());
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("{").append(this.key);
        str.append(" => ").append(this.value);
        str.append("}");
        return str.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (null == this.key) {
            throw new InvalidObjectException("attempt to deserialize map entry with null key");
        }
        this.keyHashCode = this.key.hashCode();
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new UnsupportedOperationException();
    }

    private static boolean safeEquals(Object o1, Object o2) {
        if (null == o1 != (null == o2)) {
            return false;
        }
        if (null == o1) {
            return true;
        }
        return o1.equals(o2);
    }
}

