/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection;

import java.util.NoSuchElementException;

public class SimpleStack<T> {
    private T value;
    private Item<T> head;
    private final Object[] pushArray;
    private int pushIdx;
    private static final int SINGLE_IDX = -1;
    private static final int EMPTY_IDX = -2;
    private static final int DEFAULT_PUSH_ARRAY_SIZE = 2;
    private static final String ERR_EMPTY = "stack is empty";
    private static final String ERR_NEG_CAPACITY = "stack array capacity must be non-negative";

    public SimpleStack() {
        this(2);
    }

    public SimpleStack(int arrayCapacity) {
        if (arrayCapacity < 0) {
            throw new IllegalArgumentException(ERR_NEG_CAPACITY);
        }
        this.pushArray = new Object[arrayCapacity];
    }

    public boolean isEmpty() {
        return -2 == this.pushIdx;
    }

    public T get() {
        if (-2 == this.pushIdx) {
            throw new NoSuchElementException(ERR_EMPTY);
        }
        return this.value;
    }

    public T pop() {
        if (-2 == this.pushIdx) {
            throw new NoSuchElementException(ERR_EMPTY);
        }
        T result = this.value;
        if (null != this.head) {
            this.value = this.head.value;
            this.head = this.head.next;
        } else {
            if (-1 != this.pushIdx) {
                this.value = this.pushArray[this.pushIdx];
            }
            --this.pushIdx;
        }
        return result;
    }

    public void push(T newValue) {
        if (null != this.head || this.pushArray.length - 1 == this.pushIdx) {
            this.head = new Item<T>(this.value, this.head);
            this.value = newValue;
        } else {
            ++this.pushIdx;
            if (this.pushIdx > -1) {
                this.pushArray[this.pushIdx] = this.value;
            }
            this.value = newValue;
        }
    }

    public T replace(T newValue) {
        if (-2 == this.pushIdx) {
            throw new NoSuchElementException(ERR_EMPTY);
        }
        T oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    public void clear() {
        this.value = null;
        this.head = null;
        this.pushIdx = -2;
    }

    static class Item<T> {
        protected final T value;
        protected final Item<T> next;

        protected Item(T value, Item<T> next) {
            this.value = value;
            this.next = next;
        }
    }
}

