/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.iterator;

import cz.auderis.tools.collection.iterator.Iterators;
import java.util.Iterator;

public class IndexedIteratorDecorator<T>
implements Iterator<T>,
Iterable<T> {
    private final Iterator<? extends T> baseIterator;
    private int index;
    private int trueIndex;
    private boolean afterRemove;

    public IndexedIteratorDecorator(Iterator<? extends T> baseIter) {
        this.baseIterator = null != baseIter ? baseIter : Iterators.emptyIterator();
        this.index = -1;
        this.trueIndex = -1;
        this.afterRemove = false;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.baseIterator.hasNext();
    }

    @Override
    public T next() {
        T result = this.baseIterator.next();
        if (!this.afterRemove) {
            ++this.index;
        } else {
            this.afterRemove = false;
        }
        ++this.trueIndex;
        return result;
    }

    @Override
    public void remove() {
        this.baseIterator.remove();
        this.afterRemove = true;
    }

    public int getIndex() {
        return this.index;
    }

    public int getTrueIndex() {
        return this.trueIndex;
    }
}

