/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntegerIterator
implements Iterator<Integer>,
Iterable<Integer> {
    private final int start;
    private final int step;
    private final int count;
    protected int idx;
    protected int value;

    protected IntegerIterator(int start, int count, int step) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be non-negative");
        }
        this.start = start;
        this.step = step;
        this.count = count;
        this.idx = -1;
        this.value = this.start - this.step;
    }

    public static IntegerIterator withCount(int count) {
        return new IntegerIterator(0, count, 1);
    }

    public static IntegerIterator withCountAndStep(int count, int step) {
        return new IntegerIterator(0, count, step);
    }

    public static IntegerIterator withStartCountStep(int start, int count, int step) {
        return new IntegerIterator(start, count, step);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.idx + 1 < this.count;
    }

    @Override
    public Integer next() {
        ++this.idx;
        if (this.idx >= this.count) {
            throw new NoSuchElementException();
        }
        this.value += this.step;
        return this.value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

