/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.iterator;

import cz.auderis.tools.collection.iterator.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class InterleavedIteratorDecorator<T>
implements Iterator<T>,
Iterable<T> {
    private final Iterator<? extends T> baseIterator;
    private final Iterator<? extends T> interIterator;
    private final T interValue;
    private boolean lastInterValue;
    private boolean interIterDone;

    public InterleavedIteratorDecorator(Iterator<? extends T> baseIter, Iterator<? extends T> interIter, T remainingValue) {
        this.baseIterator = null != baseIter ? baseIter : Iterators.emptyIterator();
        if (null != interIter) {
            this.interIterator = interIter;
            this.interIterDone = !this.interIterator.hasNext();
        } else {
            this.interIterator = null;
            this.interIterDone = true;
        }
        this.interValue = remainingValue;
        this.lastInterValue = true;
    }

    public InterleavedIteratorDecorator(Iterator<? extends T> baseIter, Iterator<? extends T> interIter) {
        this(baseIter, interIter, null);
    }

    public InterleavedIteratorDecorator(Iterator<? extends T> baseIter, T interVal) {
        this(baseIter, null, (T)interVal);
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.baseIterator.hasNext();
    }

    @Override
    public T next() {
        T result;
        if (!this.baseIterator.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.lastInterValue) {
            result = this.baseIterator.next();
        } else if (this.interIterDone) {
            result = this.interValue;
        } else if (!this.interIterator.hasNext()) {
            result = this.interValue;
            this.interIterDone = true;
        } else {
            result = this.interIterator.next();
        }
        this.lastInterValue = !this.lastInterValue;
        return result;
    }

    @Override
    public void remove() {
        if (!this.lastInterValue) {
            this.baseIterator.remove();
        } else if (!this.interIterDone) {
            this.interIterator.remove();
        }
    }

    public boolean isBetween() {
        return this.lastInterValue;
    }
}

