/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.iterator;

import cz.auderis.tools.collection.iterator.IterationItem;
import cz.auderis.tools.collection.iterator.Iterators;
import java.util.Arrays;
import java.util.Iterator;

public final class IterationItems<T>
implements Iterable<IterationItem<T>> {
    private final Iterator<IterationItem<T>> itemIterator;

    public static <T> IterationItems<T> of(Iterable<? extends T> source) {
        Iterator<Object> baseIterator = null == source ? Iterators.emptyIterator() : source.iterator();
        IterableItemWrapper itemIterator = new IterableItemWrapper(baseIterator);
        return new IterationItems<T>(itemIterator);
    }

    public static <T> IterationItems<T> of(Iterator<? extends T> source) {
        if (null == source) {
            throw new NullPointerException();
        }
        IterableItemWrapper<? extends T> itemIterator = new IterableItemWrapper<T>(source);
        return new IterationItems<T>(itemIterator);
    }

    @SafeVarargs
    public static <T> IterationItems<T> ofArray(T ... source) {
        Iterator baseIterator = null == source ? Iterators.emptyIterator() : Arrays.asList(source).iterator();
        IterableItemWrapper itemIterator = new IterableItemWrapper(baseIterator);
        return new IterationItems<T>(itemIterator);
    }

    private IterationItems(Iterator<IterationItem<T>> itemIterator) {
        this.itemIterator = itemIterator;
    }

    @Override
    public Iterator<IterationItem<T>> iterator() {
        return this.itemIterator;
    }

    static final class IterableItemWrapper<E>
    implements IterationItem<E>,
    Iterator<IterationItem<E>> {
        private final Iterator<? extends E> baseIterator;
        private int index;
        private E current;

        public IterableItemWrapper(Iterator<? extends E> baseIterator) {
            this.baseIterator = baseIterator;
            this.index = -1;
            this.current = null;
        }

        @Override
        public E value() {
            return this.current;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public boolean isFirst() {
            return 0 == this.index;
        }

        @Override
        public boolean isLast() {
            return !this.baseIterator.hasNext();
        }

        @Override
        public void remove() {
            this.baseIterator.remove();
        }

        @Override
        public boolean hasNext() {
            return this.baseIterator.hasNext();
        }

        @Override
        public IterationItem<E> next() {
            ++this.index;
            this.current = this.baseIterator.next();
            return this;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("iteration item is transient object, use its value instead");
        }

        public boolean equals(Object obj) {
            throw new UnsupportedOperationException("iteration item is transient object, use its value instead");
        }

        public String toString() {
            StringBuilder str = new StringBuilder("[");
            str.append(this.index);
            str.append("] ");
            str.append(this.current);
            return str.toString();
        }
    }
}

