/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.iterator;

import cz.auderis.tools.collection.iterator.IndexedIteratorDecorator;
import cz.auderis.tools.collection.iterator.InterleavedIteratorDecorator;
import cz.auderis.tools.collection.iterator.ParallelIteratorDecorator;
import cz.auderis.tools.collection.iterator.PushbackIteratorDecorator;
import cz.auderis.tools.collection.iterator.SingleItemIterator;
import java.util.Collections;
import java.util.Iterator;

public final class Iterators {
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();

    public static <T> Iterable<T> asIterable(Iterator<? extends T> baseIter) {
        if (null == baseIter) {
            return Collections.emptyList();
        }
        if (baseIter instanceof Iterable) {
            Iterable result = (Iterable)((Object)baseIter);
            return result;
        }
        final Iterator<? extends T> iter = baseIter;
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iter;
            }
        };
    }

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> SingleItemIterator<T> singleItemIterator(T item) {
        return new SingleItemIterator<T>(item);
    }

    public static <K, V> ParallelIteratorDecorator<K, V> parallelIterator(Iterator<? extends K> keyIter, Iterator<? extends V> valIter) {
        return new ParallelIteratorDecorator<K, V>(keyIter, valIter);
    }

    public static <K, V> ParallelIteratorDecorator<K, V> parallelIterable(Iterable<? extends K> keySource, Iterable<? extends V> valSource) {
        return new ParallelIteratorDecorator<K, V>(null != keySource ? keySource.iterator() : null, null != valSource ? valSource.iterator() : null);
    }

    public static <T> IndexedIteratorDecorator<T> indexedIterator(Iterator<? extends T> baseIter) {
        return new IndexedIteratorDecorator<T>(baseIter);
    }

    public static <T> IndexedIteratorDecorator<T> indexedIterable(Iterable<? extends T> baseSource) {
        return new IndexedIteratorDecorator<T>(null != baseSource ? baseSource.iterator() : null);
    }

    public static <T> PushbackIteratorDecorator<T> pushbackIterator(Iterator<? extends T> baseIter) {
        return new PushbackIteratorDecorator<T>(baseIter);
    }

    public static <T> PushbackIteratorDecorator<T> pushbackIterable(Iterable<? extends T> baseSource) {
        return new PushbackIteratorDecorator<T>(null != baseSource ? baseSource.iterator() : null);
    }

    public static <T> InterleavedIteratorDecorator<T> interleavedIterator(Iterator<? extends T> baseIter, Iterator<? extends T> interIter) {
        return new InterleavedIteratorDecorator<Iterator<? extends T>>(baseIter, interIter);
    }

    public static <T> InterleavedIteratorDecorator<T> interleavedIterator(Iterator<? extends T> base, T interValue) {
        return new InterleavedIteratorDecorator<T>(base, interValue);
    }

    public static <T> InterleavedIteratorDecorator<T> interleavedIterable(Iterable<? extends T> baseSrc, Iterable<? extends T> interSrc) {
        return new InterleavedIteratorDecorator<Iterator<? extends T>>(null != baseSrc ? baseSrc.iterator() : null, null != interSrc ? interSrc.iterator() : null);
    }

    public static <T> InterleavedIteratorDecorator<T> interleavedIterable(Iterable<? extends T> baseSrc, T interValue) {
        return new InterleavedIteratorDecorator<T>(null != baseSrc ? baseSrc.iterator() : null, interValue);
    }

    private Iterators() {
    }

    protected static final class EmptyIterator<T>
    implements Iterator<T> {
        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

