/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.iterator;

import cz.auderis.tools.collection.iterator.Iterators;
import cz.auderis.tools.collection.tuple.ImmutablePair;
import cz.auderis.tools.collection.tuple.Pair;
import java.util.Iterator;

public class ParallelIteratorDecorator<I, J>
implements Iterator<Pair<I, J>>,
Iterable<Pair<I, J>> {
    private final Iterator<? extends I> keyIterator;
    private final Iterator<? extends J> valueIterator;

    public ParallelIteratorDecorator(Iterator<? extends I> keyIter, Iterator<? extends J> valueIter) {
        this.keyIterator = null != keyIter ? keyIter : Iterators.emptyIterator();
        this.valueIterator = null != valueIter ? valueIter : Iterators.emptyIterator();
    }

    @Override
    public Iterator<Pair<I, J>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.keyIterator.hasNext() || this.valueIterator.hasNext();
    }

    public boolean hasNextKey() {
        return this.keyIterator.hasNext();
    }

    public boolean hasNextValue() {
        return this.valueIterator.hasNext();
    }

    @Override
    public Pair<I, J> next() {
        Object key = this.keyIterator.hasNext() ? (Object)this.keyIterator.next() : null;
        Object val = this.valueIterator.hasNext() ? (Object)this.valueIterator.next() : null;
        return ImmutablePair.of(key, val);
    }

    @Override
    public void remove() {
        this.keyIterator.remove();
        this.valueIterator.remove();
    }

    public void removeKey() {
        this.keyIterator.remove();
    }

    public void removeValue() {
        this.valueIterator.remove();
    }
}

