/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.iterator;

import cz.auderis.tools.collection.iterator.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PushbackIteratorDecorator<T>
implements Iterator<T>,
Iterable<T> {
    private final Iterator<? extends T> baseIterator;
    private List<T> pushbackBuffer;
    private boolean lastFromBuffer;
    private T lastItem;

    public PushbackIteratorDecorator(Iterator<? extends T> baseIter) {
        this.baseIterator = null != baseIter ? baseIter : Iterators.emptyIterator();
        this.pushbackBuffer = null;
        this.lastFromBuffer = false;
        this.lastItem = null;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (null != this.pushbackBuffer && !this.pushbackBuffer.isEmpty()) {
            return true;
        }
        return this.baseIterator.hasNext();
    }

    @Override
    public T next() {
        this.lastFromBuffer = null != this.pushbackBuffer && !this.pushbackBuffer.isEmpty();
        this.lastItem = this.lastFromBuffer ? this.pushbackBuffer.remove(0) : this.baseIterator.next();
        return this.lastItem;
    }

    @Override
    public void remove() {
        if (!this.lastFromBuffer) {
            this.baseIterator.remove();
        }
    }

    public void pushback() {
        this.pushback(this.lastItem);
    }

    public void pushback(T item) {
        if (null == this.pushbackBuffer) {
            this.pushbackBuffer = new LinkedList<T>();
        }
        this.pushbackBuffer.add(item);
    }

    public void pushback(Collection<? extends T> items) {
        if (null == items) {
            return;
        }
        if (null == this.pushbackBuffer) {
            this.pushbackBuffer = new LinkedList<T>(items);
        } else {
            this.pushbackBuffer.addAll(items);
        }
    }

    public void clearBuffer() {
        if (null != this.pushbackBuffer) {
            this.pushbackBuffer.clear();
        }
    }
}

