/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class SingleItemIterator<T>
implements Iterator<T>,
Iterable<T> {
    private T itemReference;
    private boolean exhausted;

    public SingleItemIterator() {
        this(null);
    }

    public SingleItemIterator(T item) {
        this.itemReference = item;
        this.exhausted = false;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return !this.exhausted;
    }

    @Override
    public T next() {
        if (this.exhausted) {
            throw new NoSuchElementException();
        }
        this.exhausted = true;
        return this.itemReference;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.exhausted = false;
    }

    public void reset(T newItem) {
        this.itemReference = newItem;
        this.exhausted = false;
    }
}

