/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.topo;

import cz.auderis.tools.collection.AlwaysEmptySet;
import cz.auderis.tools.collection.topo.TopoNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class BasicTopoNode<K, V>
implements TopoNode<K, V> {
    private static final Set<?> EMPTY_MUTABLE_SET = new AlwaysEmptySet();
    private final K key;
    private final V value;
    private Set<K> dependencies;

    public static <K1, V1> BasicTopoNode<K1, V1> create(K1 key, V1 value) {
        if (null == key) {
            throw new NullPointerException();
        }
        return new BasicTopoNode<K1, V1>(key, value);
    }

    public static <K1, V1> BasicTopoNode<K1, V1> createWithDependencies(K1 key, V1 value, Collection<? extends K1> dependencies) {
        if (null == key) {
            throw new NullPointerException();
        }
        BasicTopoNode<K1, V1> newNode = new BasicTopoNode<K1, V1>(key, value);
        if (null != dependencies && !dependencies.isEmpty()) {
            newNode.setDependencies(dependencies);
        }
        return newNode;
    }

    public static <K1, V1> BasicTopoNode<K1, V1> createWithDependencies(K1 key, V1 value, K1 ... dependencies) {
        if (null == key) {
            throw new NullPointerException();
        }
        BasicTopoNode<K1, V1> newNode = new BasicTopoNode<K1, V1>(key, value);
        if (null != dependencies && 0 != dependencies.length) {
            newNode.setDependencies(Arrays.asList(dependencies));
        }
        return newNode;
    }

    @Override
    public K getTopoKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public final Set<K> getRemainingTopoDependencies() {
        return this.dependencies;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TopoNode)) {
            return false;
        }
        TopoNode other = (TopoNode)obj;
        Object otherKey = other.getTopoKey();
        return this.key.equals(otherKey);
    }

    public String toString() {
        return this.key.toString();
    }

    protected BasicTopoNode(K key, V value) {
        this.key = key;
        this.value = value;
        Set<?> emptySet = EMPTY_MUTABLE_SET;
        this.dependencies = emptySet;
    }

    protected void setDependencies(Collection<? extends K> deps) {
        int newCount = deps.size();
        if (0 == newCount) {
            Set<?> emptySet = EMPTY_MUTABLE_SET;
            this.dependencies = emptySet;
            return;
        }
        if (this.dependencies == EMPTY_MUTABLE_SET) {
            this.dependencies = new HashSet<K>(newCount);
        }
        this.dependencies.clear();
        for (K dep : deps) {
            if (null == dep) continue;
            this.dependencies.add(dep);
        }
    }
}

